/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.support;

import aQute.lib.osgi.Jar;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.jar.Attributes;
import org.fusesource.common.util.Filter;
import org.fusesource.common.util.Strings;
import org.fusesource.fabric.fab.DependencyFilters;
import org.fusesource.fabric.fab.DependencyTreeResult;
import org.fusesource.fabric.fab.MavenResolverImpl;
import org.fusesource.process.manager.JarInstallParameters;
import org.fusesource.process.manager.config.ProcessConfig;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.resolution.ArtifactResolutionException;

public class JarInstaller {
    MavenResolverImpl mavenResolver = new MavenResolverImpl();
    private final Executor executor;

    public JarInstaller(Executor executor) {
        this.executor = executor;
    }

    public void unpackJarProcess(ProcessConfig config, int id, File installDir, JarInstallParameters parameters) throws Exception {
        Filter optionalFilter = DependencyFilters.parseExcludeOptionalFilter((String)Strings.join(Arrays.asList(parameters.getOptionalDependencyPatterns()), (String)" "));
        Filter excludeFilter = DependencyFilters.parseExcludeFilter((String)Strings.join(Arrays.asList(parameters.getExcludeDependencyFilterPatterns()), (String)" "), (Filter)optionalFilter);
        DependencyTreeResult result = this.mavenResolver.collectDependencies(parameters.getGroupId(), parameters.getArtifactId(), parameters.getVersion(), parameters.getExtension(), parameters.getClassifier(), parameters.isOffline(), excludeFilter);
        DependencyNode mainJarDependency = result.getRootNode();
        File libDir = new File(installDir, "lib");
        libDir.mkdirs();
        File mainJar = this.getFile(mainJarDependency);
        if (mainJar == null) {
            System.out.println("Cannot find file for main jar " + mainJarDependency);
        } else {
            File newMain = new File(libDir, "main.jar");
            Files.copy((File)mainJar, (File)newMain);
            String mainClass = parameters.getMainClass();
            if (mainClass != null) {
                this.setMainClass(config, installDir, newMain, id, mainClass);
            }
        }
        this.copyDependencies(mainJarDependency, libDir);
    }

    protected void setMainClass(ProcessConfig config, File installDir, File jarFile, int id, String mainClass) throws Exception {
        File tmpFile = File.createTempFile("fuse-process-" + id, ".jar");
        Files.copy((File)jarFile, (File)tmpFile);
        Jar jar = new Jar(tmpFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        attributes.putValue("Main-Class", mainClass);
        jar.write(jarFile);
    }

    protected void copyDependencies(DependencyNode dependency, File libDir) throws IOException, ArtifactResolutionException {
        List children = dependency.getChildren();
        if (children != null) {
            for (DependencyNode child : children) {
                File file = this.getFile(child);
                if (file == null) {
                    System.out.println("Cannot find file for dependent jar " + child);
                } else {
                    Files.copy((File)file, (File)new File(libDir, file.getName()));
                }
                this.copyDependencies(child, libDir);
            }
        }
    }

    protected File getFile(DependencyNode node) throws ArtifactResolutionException {
        Artifact artifact;
        Dependency dependency;
        if (node != null && (dependency = node.getDependency()) != null && (artifact = dependency.getArtifact()) != null) {
            File file = artifact.getFile();
            if (file == null) {
                return this.mavenResolver.resolveFile(artifact);
            }
            return file;
        }
        return null;
    }
}

