/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.commands;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.fusesource.process.manager.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KindCompleter
implements Completer {
    private static final transient Logger LOG = LoggerFactory.getLogger(KindCompleter.class);
    private List<String> kinds = Lists.newArrayList();

    public void init() {
        InputStream in = ProcessManager.class.getResourceAsStream("controllerKinds");
        if (in == null) {
            LOG.warn("Cannot find controllerKinds on the classpath!");
        } else {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    this.kinds.add(line);
                }
            }
            catch (IOException e) {
                Closeables.closeQuietly((Closeable)in);
            }
        }
    }

    public int complete(String buffer, int cursor, List candidates) {
        StringsCompleter delegate = new StringsCompleter(this.kinds);
        return delegate.complete(buffer, cursor, candidates);
    }
}

