/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager.support;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.Executor;
import org.fusesource.process.manager.ProcessController;
import org.fusesource.process.manager.config.ProcessConfig;
import org.fusesource.process.manager.support.command.CommandFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessController
implements ProcessController {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultProcessController.class);
    private final int id;
    private final File baseDir;
    private final ProcessConfig config;
    private final Executor executor;

    public DefaultProcessController(int id, ProcessConfig config, Executor executor, File baseDir) {
        this.id = id;
        this.config = config;
        this.executor = executor;
        this.baseDir = baseDir;
    }

    public String toString() {
        return "DefaultProcessController(" + this.id + ")";
    }

    @Override
    public int install() throws InterruptedException, IOException, CommandFailedException {
        int answer = 0;
        List<String> installCommands = this.config.getInstallCommands();
        if (installCommands != null) {
            for (String installCommand : installCommands) {
                if (Strings.isNullOrEmpty((String)installCommand)) continue;
                this.runCommandLine(installCommand);
            }
        }
        return answer;
    }

    @Override
    public int uninstall() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int start() throws Exception {
        return this.runConfigCommandValueOrLaunchScriptWith(this.config.getStartCommand(), "start");
    }

    @Override
    public int stop() throws Exception {
        return this.runConfigCommandValueOrLaunchScriptWith(this.config.getStopCommand(), "stop");
    }

    @Override
    public int kill() throws Exception {
        String customCommand = this.config.getKillCommand();
        if (customCommand != null && customCommand.trim().isEmpty()) {
            LOG.info("No kill command configured so lets just try stopping " + this);
            return this.stop();
        }
        return this.runConfigCommandValueOrLaunchScriptWith(customCommand, "kill");
    }

    @Override
    public int restart() throws Exception {
        String customCommand = this.config.getRestartCommand();
        if (customCommand != null && customCommand.trim().isEmpty()) {
            LOG.info("No restart command configured so lets just try stopping " + this + " then starting again.");
            int answer = this.stop();
            if (answer == 0) {
                answer = this.start();
            }
            return answer;
        }
        return this.runConfigCommandValueOrLaunchScriptWith(customCommand, "restart");
    }

    @Override
    public int status() throws Exception {
        return this.runConfigCommandValueOrLaunchScriptWith(this.config.getStatusCommand(), "status");
    }

    @Override
    public int configure() throws Exception {
        String customCommand = this.config.getConfigureCommand();
        if (customCommand != null && customCommand.trim().isEmpty()) {
            LOG.info("No configure command configured " + this);
            return 0;
        }
        return this.runCommandLine(customCommand);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Integer getPid() throws IOException {
        File file;
        Integer answer = null;
        String pidFileName = this.config.getPidFile();
        if (pidFileName != null && (file = new File(this.baseDir, pidFileName)).exists() && file.isFile()) {
            return this.extractPidFromFile(file);
        }
        File pidFile = new File(this.baseDir, "var/process.pid");
        if (pidFile.exists()) {
            return this.extractPidFromFile(pidFile);
        }
        File pidDir = new File(this.baseDir, "var/run");
        if (pidDir.exists() && pidDir.isDirectory()) {
            String launchScript = this.getLaunchScript();
            String script = launchScript;
            int idx = script.lastIndexOf("/");
            if (idx < 0) {
                idx = script.lastIndexOf("\\");
            }
            if (idx > 0) {
                script = script.substring(idx + 1);
            }
            if ((pidFile = new File(pidDir, script + ".pid")).exists()) {
                return this.extractPidFromFile(pidFile);
            }
            if (answer == null) {
                File file2;
                File[] files;
                File[] arr$ = files = pidDir.listFiles();
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || (file2 = arr$[i$]).getName().toLowerCase().endsWith(".pid") && (answer = this.extractPidFromFile(file2)) != null); ++i$) {
                }
            }
        }
        return answer;
    }

    protected String getLaunchScript() {
        String launchScript = this.config.getLaunchScript();
        if (launchScript == null) {
            launchScript = "bin/launcher";
        }
        return launchScript;
    }

    private Integer extractPidFromFile(File file) throws IOException {
        List lines = Files.readLines((File)file, (Charset)Charset.defaultCharset());
        for (String line : lines) {
            String text = line.trim();
            if (!text.matches("\\d+")) continue;
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse pid '" + text + "' as a number. Exception: " + e, e);
            }
        }
        return null;
    }

    protected int runConfigCommandValueOrLaunchScriptWith(String command, String launchArgument) throws InterruptedException, IOException, CommandFailedException {
        if (command != null) {
            return this.runCommandLine(command);
        }
        return this.config.runCommand(this.executor, this.baseDir, this.getLaunchScript(), launchArgument);
    }

    protected int runCommandLine(String command) throws IOException, InterruptedException, CommandFailedException {
        if (command != null) {
            String[] commandArgs = command.split("\\s+");
            return this.config.runCommand(this.executor, this.baseDir, commandArgs);
        }
        return 0;
    }
}

