/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.fusesource.fabric.dosgi.io.ProtocolCodec;
import org.fusesource.fabric.dosgi.io.Transport;
import org.fusesource.fabric.dosgi.io.TransportListener;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;
import org.fusesource.hawtdispatch.Retained;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransport.class);
    protected State _serviceState = CREATED;
    protected Map<String, Object> socketOptions;
    public static final State CREATED = new State();
    public static final State STARTED = new State(){

        @Override
        public boolean isStarted() {
            return true;
        }
    };
    public static final State STOPPED = new State();
    protected URI remoteLocation;
    protected URI localLocation;
    protected TransportListener listener;
    protected String remoteAddress;
    protected ProtocolCodec codec;
    protected SocketChannel channel;
    protected SocketState socketState = new DISCONNECTED();
    protected DispatchQueue dispatchQueue;
    private DispatchSource readSource;
    private DispatchSource writeSource;
    protected boolean useLocalHost = true;
    int max_read_rate;
    int max_write_rate;
    protected RateLimitingChannel rateLimitingChannel;
    private final Runnable CANCEL_HANDLER = new Runnable(){

        @Override
        public void run() {
            TcpTransport.this.socketState.onCanceled();
        }
    };
    boolean drained = true;

    @Override
    public final void start() {
        this.start(null);
    }

    @Override
    public final void stop() {
        this.stop(null);
    }

    @Override
    public final void start(final Runnable onCompleted) {
        this.queue().execute(new Runnable(){

            @Override
            public void run() {
                if (TcpTransport.this._serviceState == CREATED || TcpTransport.this._serviceState == STOPPED) {
                    final STARTING state = new STARTING();
                    state.add(onCompleted);
                    TcpTransport.this._serviceState = state;
                    TcpTransport.this._start(new Runnable(){

                        @Override
                        public void run() {
                            TcpTransport.this._serviceState = STARTED;
                            state.done();
                        }
                    });
                } else if (TcpTransport.this._serviceState instanceof STARTING) {
                    ((STARTING)TcpTransport.this._serviceState).add(onCompleted);
                } else if (TcpTransport.this._serviceState == STARTED) {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                } else {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                    LOG.error("start should not be called from state: " + TcpTransport.this._serviceState);
                }
            }
        });
    }

    @Override
    public final void stop(final Runnable onCompleted) {
        this.queue().execute(new Runnable(){

            @Override
            public void run() {
                if (TcpTransport.this._serviceState == STARTED) {
                    final STOPPING state = new STOPPING();
                    state.add(onCompleted);
                    TcpTransport.this._serviceState = state;
                    TcpTransport.this._stop(new Runnable(){

                        @Override
                        public void run() {
                            TcpTransport.this._serviceState = STOPPED;
                            state.done();
                        }
                    });
                } else if (TcpTransport.this._serviceState instanceof STOPPING) {
                    ((STOPPING)TcpTransport.this._serviceState).add(onCompleted);
                } else if (TcpTransport.this._serviceState == STOPPED) {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                } else {
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                    LOG.error("stop should not be called from state: " + TcpTransport.this._serviceState);
                }
            }
        });
    }

    protected State getServiceState() {
        return this._serviceState;
    }

    public void connected(SocketChannel channel) throws IOException, Exception {
        this.channel = channel;
        if (this.codec != null) {
            this.initializeCodec();
        }
        this.channel.configureBlocking(false);
        this.remoteAddress = channel.socket().getRemoteSocketAddress().toString();
        channel.socket().setSoLinger(true, 0);
        channel.socket().setTcpNoDelay(true);
        this.socketState = new CONNECTED();
    }

    protected void initializeCodec() {
        this.codec.setReadableByteChannel(this.readChannel());
        this.codec.setWritableByteChannel(this.writeChannel());
    }

    public void connecting(URI remoteLocation, URI localLocation) throws IOException, Exception {
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.remoteLocation = remoteLocation;
        this.localLocation = localLocation;
        if (localLocation != null) {
            InetSocketAddress localAddress = new InetSocketAddress(InetAddress.getByName(localLocation.getHost()), localLocation.getPort());
            this.channel.socket().bind(localAddress);
        }
        String host = this.resolveHostName(remoteLocation.getHost());
        InetSocketAddress remoteAddress = new InetSocketAddress(host, remoteLocation.getPort());
        this.channel.connect(remoteAddress);
        this.socketState = new CONNECTING();
    }

    @Override
    public DispatchQueue queue() {
        return this.dispatchQueue;
    }

    @Override
    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _start(Runnable onCompleted) {
        try {
            if (this.socketState.is(CONNECTING.class)) {
                this.trace("connecting...");
                this.readSource = Dispatch.createSource((SelectableChannel)this.channel, (int)8, (DispatchQueue)this.dispatchQueue);
                this.readSource.setEventHandler(new Runnable(){

                    @Override
                    public void run() {
                        if (TcpTransport.this.getServiceState() != STARTED) {
                            return;
                        }
                        try {
                            TcpTransport.this.trace("connected.");
                            TcpTransport.this.channel.finishConnect();
                            TcpTransport.this.readSource.setCancelHandler(null);
                            TcpTransport.this.readSource.cancel();
                            TcpTransport.this.readSource = null;
                            TcpTransport.this.socketState = new CONNECTED();
                            TcpTransport.this.onConnected();
                        }
                        catch (IOException e) {
                            TcpTransport.this.onTransportFailure(e);
                        }
                    }
                });
                this.readSource.setCancelHandler(this.CANCEL_HANDLER);
                this.readSource.resume();
            } else if (this.socketState.is(CONNECTED.class)) {
                this.dispatchQueue.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TcpTransport.this.trace("was connected.");
                            TcpTransport.this.onConnected();
                        }
                        catch (IOException e) {
                            TcpTransport.this.onTransportFailure(e);
                        }
                    }
                });
            } else {
                System.err.println("cannot be started.  socket state is: " + this.socketState);
            }
        }
        finally {
            if (onCompleted != null) {
                onCompleted.run();
            }
        }
    }

    public void _stop(Runnable onCompleted) {
        this.trace("stopping.. at state: " + this.socketState);
        this.socketState.onStop(onCompleted);
    }

    protected String resolveHostName(String host) throws UnknownHostException {
        String localName = InetAddress.getLocalHost().getHostName();
        if (localName != null && this.isUseLocalHost() && localName.equals(host)) {
            return "localhost";
        }
        return host;
    }

    protected void onConnected() throws IOException {
        this.readSource = Dispatch.createSource((SelectableChannel)this.channel, (int)1, (DispatchQueue)this.dispatchQueue);
        this.writeSource = Dispatch.createSource((SelectableChannel)this.channel, (int)4, (DispatchQueue)this.dispatchQueue);
        this.readSource.setCancelHandler(this.CANCEL_HANDLER);
        this.writeSource.setCancelHandler(this.CANCEL_HANDLER);
        this.readSource.setEventHandler(new Runnable(){

            @Override
            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
        this.writeSource.setEventHandler(new Runnable(){

            @Override
            public void run() {
                TcpTransport.this.drainOutbound();
            }
        });
        if (this.max_read_rate != 0 || this.max_write_rate != 0) {
            this.rateLimitingChannel = new RateLimitingChannel();
            this.schedualRateAllowanceReset();
        }
        this.remoteAddress = this.channel.socket().getRemoteSocketAddress().toString();
        this.listener.onTransportConnected(this);
    }

    private void schedualRateAllowanceReset() {
        this.dispatchQueue.executeAfter(1L, TimeUnit.SECONDS, new Runnable(){

            @Override
            public void run() {
                if (!TcpTransport.this.socketState.is(CONNECTED.class)) {
                    return;
                }
                TcpTransport.this.rateLimitingChannel.resetAllowance();
                TcpTransport.this.schedualRateAllowanceReset();
            }
        });
    }

    private void dispose() {
        if (this.readSource != null) {
            this.readSource.cancel();
            this.readSource = null;
        }
        if (this.writeSource != null) {
            this.writeSource.cancel();
            this.writeSource = null;
        }
        this.codec = null;
    }

    public void onTransportFailure(IOException error) {
        this.listener.onTransportFailure(this, error);
        this.socketState.onCanceled();
    }

    @Override
    public boolean full() {
        return this.codec.full();
    }

    @Override
    public boolean offer(Object command) {
        assert (Dispatch.getCurrentQueue() == this.dispatchQueue);
        try {
            if (!this.socketState.is(CONNECTED.class)) {
                throw new IOException("Not connected.");
            }
            if (this.getServiceState() != STARTED) {
                throw new IOException("Not running.");
            }
            ProtocolCodec.BufferState rc = this.codec.write(command);
            switch (rc) {
                case FULL: {
                    return false;
                }
            }
            if (this.drained) {
                this.drained = false;
                this.resumeWrite();
            }
            return true;
        }
        catch (IOException e) {
            this.onTransportFailure(e);
            return false;
        }
    }

    protected void drainOutbound() {
        assert (Dispatch.getCurrentQueue() == this.dispatchQueue);
        if (this.getServiceState() != STARTED || !this.socketState.is(CONNECTED.class)) {
            return;
        }
        try {
            if (this.codec.flush() == ProtocolCodec.BufferState.EMPTY && this.flush() && !this.drained) {
                this.drained = true;
                this.suspendWrite();
                this.listener.onRefill(this);
            }
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
    }

    protected boolean flush() throws IOException {
        return true;
    }

    protected void drainInbound() {
        if (!this.getServiceState().isStarted() || this.readSource.isSuspended()) {
            return;
        }
        try {
            long initial = this.codec.getReadCounter();
            while (this.codec.getReadCounter() - initial < 65536L) {
                Object command = this.codec.read();
                if (command != null) {
                    try {
                        this.listener.onTransportCommand(this, command);
                    }
                    catch (Throwable e) {
                        this.onTransportFailure(new IOException("Transport listener failure."));
                    }
                    if (this.getServiceState() != STOPPED && !this.readSource.isSuspended()) continue;
                    return;
                }
                return;
            }
        }
        catch (IOException e) {
            this.onTransportFailure(e);
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    private boolean assertConnected() {
        try {
            if (!this.isConnected()) {
                throw new IOException("Not connected.");
            }
            return true;
        }
        catch (IOException e) {
            this.onTransportFailure(e);
            return false;
        }
    }

    @Override
    public void suspendRead() {
        if (this.isConnected() && this.readSource != null) {
            this.readSource.suspend();
        }
    }

    @Override
    public void resumeRead() {
        if (this.isConnected() && this.readSource != null) {
            if (this.rateLimitingChannel != null) {
                this.rateLimitingChannel.resumeRead();
            } else {
                this._resumeRead();
            }
        }
    }

    private void _resumeRead() {
        this.readSource.resume();
        this.dispatchQueue.execute(new Runnable(){

            @Override
            public void run() {
                TcpTransport.this.drainInbound();
            }
        });
    }

    protected void suspendWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.suspend();
        }
    }

    protected void resumeWrite() {
        if (this.isConnected() && this.writeSource != null) {
            this.writeSource.resume();
            this.dispatchQueue.execute(new Runnable(){

                @Override
                public void run() {
                    TcpTransport.this.drainOutbound();
                }
            });
        }
    }

    @Override
    public TransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public void setTransportListener(TransportListener listener) {
        this.listener = listener;
    }

    @Override
    public ProtocolCodec getProtocolCodec() {
        return this.codec;
    }

    @Override
    public void setProtocolCodec(ProtocolCodec protocolCodec) {
        this.codec = protocolCodec;
        if (this.channel != null && this.codec != null) {
            this.initializeCodec();
        }
    }

    @Override
    public boolean isConnected() {
        return this.socketState.is(CONNECTED.class);
    }

    @Override
    public boolean isDisposed() {
        return this.getServiceState() == STOPPED;
    }

    public void setSocketOptions(Map<String, Object> socketOptions) {
        this.socketOptions = socketOptions;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    private void trace(String message) {
        if (LOG.isTraceEnabled()) {
            String label = this.dispatchQueue.getLabel();
            if (label != null) {
                LOG.trace(label + " | " + message);
            } else {
                LOG.trace(message);
            }
        }
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public ReadableByteChannel readChannel() {
        if (this.rateLimitingChannel != null) {
            return this.rateLimitingChannel;
        }
        return this.channel;
    }

    public WritableByteChannel writeChannel() {
        if (this.rateLimitingChannel != null) {
            return this.rateLimitingChannel;
        }
        return this.channel;
    }

    public int getMax_read_rate() {
        return this.max_read_rate;
    }

    public void setMax_read_rate(int max_read_rate) {
        this.max_read_rate = max_read_rate;
    }

    public int getMax_write_rate() {
        return this.max_write_rate;
    }

    public void setMax_write_rate(int max_write_rate) {
        this.max_write_rate = max_write_rate;
    }

    static final class OneWay {
        final Object command;
        final Retained retained;

        public OneWay(Object command, Retained retained) {
            this.command = command;
            this.retained = retained;
        }
    }

    class RateLimitingChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        int read_allowance;
        boolean read_suspended;
        int read_resume_counter;
        int write_allowance;
        boolean write_suspended;

        RateLimitingChannel() {
            this.read_allowance = TcpTransport.this.max_read_rate;
            this.read_suspended = false;
            this.read_resume_counter = 0;
            this.write_allowance = TcpTransport.this.max_write_rate;
            this.write_suspended = false;
        }

        public void resetAllowance() {
            if (this.read_allowance != TcpTransport.this.max_read_rate || this.write_allowance != TcpTransport.this.max_write_rate) {
                this.read_allowance = TcpTransport.this.max_read_rate;
                this.write_allowance = TcpTransport.this.max_write_rate;
                if (this.write_suspended) {
                    this.write_suspended = false;
                    TcpTransport.this.resumeWrite();
                }
                if (this.read_suspended) {
                    this.read_suspended = false;
                    this.resumeRead();
                    for (int i = 0; i < this.read_resume_counter; ++i) {
                        this.resumeRead();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (TcpTransport.this.max_read_rate == 0) {
                return TcpTransport.this.channel.read(dst);
            }
            int remaining = dst.remaining();
            if (this.read_allowance == 0 || remaining == 0) {
                return 0;
            }
            int reduction = 0;
            if (remaining > this.read_allowance) {
                reduction = remaining - this.read_allowance;
                dst.limit(dst.limit() - reduction);
            }
            int rc = 0;
            try {
                rc = TcpTransport.this.channel.read(dst);
                this.read_allowance -= rc;
            }
            finally {
                if (reduction != 0) {
                    if (dst.remaining() == 0) {
                        TcpTransport.this.readSource.suspend();
                        this.read_suspended = true;
                    }
                    dst.limit(dst.limit() + reduction);
                }
            }
            return rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws IOException {
            if (TcpTransport.this.max_write_rate == 0) {
                return TcpTransport.this.channel.write(src);
            }
            int remaining = src.remaining();
            if (this.write_allowance == 0 || remaining == 0) {
                return 0;
            }
            int reduction = 0;
            if (remaining > this.write_allowance) {
                reduction = remaining - this.write_allowance;
                src.limit(src.limit() - reduction);
            }
            int rc = 0;
            try {
                rc = TcpTransport.this.channel.write(src);
                this.write_allowance -= rc;
            }
            finally {
                if (reduction != 0) {
                    if (src.remaining() == 0) {
                        this.write_suspended = true;
                        TcpTransport.this.suspendWrite();
                    }
                    src.limit(src.limit() + reduction);
                }
            }
            return rc;
        }

        @Override
        public boolean isOpen() {
            return TcpTransport.this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            TcpTransport.this.channel.close();
        }

        public void resumeRead() {
            if (this.read_suspended) {
                ++this.read_resume_counter;
            } else {
                TcpTransport.this._resumeRead();
            }
        }
    }

    class CANCELED
    extends SocketState {
        private boolean disposed;

        public CANCELED(boolean disposed) {
            this.disposed = disposed;
        }

        @Override
        void onStop(Runnable onCompleted) {
            TcpTransport.this.trace("CANCELED.onStop");
            if (!this.disposed) {
                this.disposed = true;
                TcpTransport.this.dispose();
            }
            onCompleted.run();
        }
    }

    class CANCELING
    extends SocketState {
        private LinkedList<Runnable> runnables = new LinkedList();
        private int remaining;
        private boolean dispose;

        public CANCELING() {
            if (TcpTransport.this.readSource != null) {
                ++this.remaining;
                TcpTransport.this.readSource.cancel();
            }
            if (TcpTransport.this.writeSource != null) {
                ++this.remaining;
                TcpTransport.this.writeSource.cancel();
            }
        }

        @Override
        void onStop(Runnable onCompleted) {
            TcpTransport.this.trace("CANCELING.onCompleted");
            this.add(onCompleted);
            this.dispose = true;
        }

        void add(Runnable onCompleted) {
            if (onCompleted != null) {
                this.runnables.add(onCompleted);
            }
        }

        @Override
        void onCanceled() {
            TcpTransport.this.trace("CANCELING.onCanceled");
            --this.remaining;
            if (this.remaining != 0) {
                return;
            }
            try {
                TcpTransport.this.channel.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            TcpTransport.this.socketState = new CANCELED(this.dispose);
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            if (this.dispose) {
                TcpTransport.this.dispose();
            }
        }
    }

    class CONNECTED
    extends SocketState {
        CONNECTED() {
        }

        @Override
        void onStop(Runnable onCompleted) {
            TcpTransport.this.trace("CONNECTED.onStop");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.add(this.createDisconnectTask());
            state.onStop(onCompleted);
        }

        @Override
        void onCanceled() {
            TcpTransport.this.trace("CONNECTED.onCanceled");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.add(this.createDisconnectTask());
            state.onCanceled();
        }

        Runnable createDisconnectTask() {
            return new Runnable(){

                @Override
                public void run() {
                    TcpTransport.this.listener.onTransportDisconnected(TcpTransport.this);
                }
            };
        }
    }

    class CONNECTING
    extends SocketState {
        CONNECTING() {
        }

        @Override
        void onStop(Runnable onCompleted) {
            TcpTransport.this.trace("CONNECTING.onStop");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.onStop(onCompleted);
        }

        @Override
        void onCanceled() {
            TcpTransport.this.trace("CONNECTING.onCanceled");
            CANCELING state = new CANCELING();
            TcpTransport.this.socketState = state;
            state.onCanceled();
        }
    }

    static class DISCONNECTED
    extends SocketState {
        DISCONNECTED() {
        }
    }

    public static class STOPPING
    extends CallbackSupport {
    }

    public static class STARTING
    extends CallbackSupport {
    }

    static abstract class SocketState {
        SocketState() {
        }

        void onStop(Runnable onCompleted) {
        }

        void onCanceled() {
        }

        boolean is(Class<? extends SocketState> clazz) {
            return this.getClass() == clazz;
        }
    }

    static class CallbackSupport
    extends State {
        LinkedList<Runnable> callbacks = new LinkedList();

        CallbackSupport() {
        }

        void add(Runnable r) {
            if (r != null) {
                this.callbacks.add(r);
            }
        }

        void done() {
            for (Runnable callback : this.callbacks) {
                callback.run();
            }
        }
    }

    public static class State {
        public String toString() {
            return this.getClass().getSimpleName();
        }

        public boolean isStarted() {
            return false;
        }
    }
}

