/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.Watcher;
import org.fusesource.fabric.zookeeper.internal.ZooKeeperAware;
import org.linkedin.util.clock.Timespan;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.client.ZKClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKClientFactoryBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(ZKClientFactoryBean.class);
    private String connectString = "";
    private String timeoutText = "30s";
    private Watcher watcher;
    private List<LifecycleListener> listeners = new ArrayList<LifecycleListener>();
    private Timespan timeout;
    protected ZKClient zkClient;
    private Timespan connectTimeout;
    private String connectTimeoutText = "10s";
    private List<LifecycleListener> dynListeners = new ArrayList<LifecycleListener>();

    public String getConnectString() {
        return this.connectString;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    public Timespan getTimeout() {
        if (this.timeout == null) {
            this.timeout = Timespan.parse((String)this.timeoutText);
        }
        return this.timeout;
    }

    public void setTimeout(Timespan timeout) {
        this.timeout = timeout;
    }

    public String getTimeoutText() {
        return this.timeoutText;
    }

    public void setTimeoutText(String timeoutText) {
        this.timeoutText = timeoutText;
    }

    public Watcher getWatcher() {
        return this.watcher;
    }

    public void setWatcher(Watcher watcher) {
        this.watcher = watcher;
    }

    public Timespan getConnectTimeout() {
        if (this.connectTimeout == null) {
            this.connectTimeout = Timespan.parse((String)this.connectTimeoutText);
        }
        return this.connectTimeout;
    }

    public void setConnectTimeout(Timespan connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getConnectTimeoutText() {
        return this.connectTimeoutText;
    }

    public void setConnectTimeoutText(String connectTimeoutText) {
        this.connectTimeoutText = connectTimeoutText;
    }

    public List<LifecycleListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<LifecycleListener> listeners) {
        this.listeners = listeners;
    }

    public synchronized void registerListener(LifecycleListener listener) {
        if (this.dynListeners.add(listener) && this.zkClient != null) {
            this.zkClient.registerListener(listener);
        }
    }

    public synchronized void unregisterListener(LifecycleListener listener) {
        if (this.dynListeners.remove(listener) && this.zkClient != null) {
            this.zkClient.removeListener(listener);
        }
    }

    public synchronized IZKClient getObject() throws Exception {
        LOG.debug("Connecting to ZooKeeper at " + this.connectString);
        this.zkClient = new ZKClient(this.connectString, this.getTimeout(), this.watcher);
        if (this.connectString.length() == 0) {
            LOG.info("No ZooKeeper URL provided. No connection attempted.");
            return this.zkClient;
        }
        this.zkClient.registerListener(new LifecycleListener(){
            final String address;
            {
                this.address = ZKClientFactoryBean.this.connectString;
            }

            public void onConnected() {
                LOG.debug("Connected to Zookeeper at " + this.address);
            }

            public void onDisconnected() {
                LOG.debug("Disconnected from ZooKeeper at " + this.address);
            }
        });
        for (LifecycleListener listener : this.dynListeners) {
            this.zkClient.registerListener(listener);
        }
        for (LifecycleListener listener : this.listeners) {
            if (listener instanceof ZooKeeperAware) {
                ((ZooKeeperAware)listener).setZooKeeper((IZKClient)this.zkClient);
            }
            this.zkClient.registerListener(listener);
        }
        this.zkClient.start();
        return this.zkClient;
    }

    public Class<?> getObjectType() {
        return IZKClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public synchronized void destroy() throws Exception {
        if (this.zkClient != null) {
            for (LifecycleListener listener : this.dynListeners) {
                this.zkClient.removeListener(listener);
            }
            for (LifecycleListener listener : this.listeners) {
                this.zkClient.removeListener(listener);
            }
            this.zkClient.destroy();
            this.zkClient = null;
        }
    }
}

