/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.commands.fab;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.osgi.internal.FabClassPathResolver;

public class TreeHelper {
    private Set<DependencyTree> allDependencies;
    private Set<DependencyTree> sharedDependencies;

    public static void write(PrintStream writer, FabClassPathResolver resolver) {
        TreeHelper treeHelper = TreeHelper.newInstance(resolver);
        DependencyTree rootTree = resolver.getRootTree();
        treeHelper.write(writer, rootTree, new boolean[0]);
    }

    public static TreeHelper newInstance(FabClassPathResolver resolver) {
        HashSet<DependencyTree> sharedDependencies = new HashSet<DependencyTree>(resolver.getSharedDependencies());
        HashSet<DependencyTree> allDependencies = new HashSet<DependencyTree>(resolver.getNonSharedDependencies());
        allDependencies.addAll(sharedDependencies);
        return new TreeHelper(allDependencies, sharedDependencies);
    }

    public TreeHelper(Set<DependencyTree> allDependencies, Set<DependencyTree> sharedDependencies) {
        this.allDependencies = allDependencies;
        this.sharedDependencies = sharedDependencies;
    }

    public void write(PrintStream writer, DependencyTree node, boolean ... indents) {
        for (boolean indent : indents) {
            writer.printf("%-3s", indent ? "|" : "");
        }
        String postfix = "";
        if (node.isOptional()) {
            postfix = postfix + " (optional)";
        }
        if (this.sharedDependencies.contains(node)) {
            postfix = " (shared)";
        }
        writer.println("+- " + node.getBundleSymbolicName() + " [" + node.getVersion() + "]" + postfix);
        ArrayList<DependencyTree> children = new ArrayList<DependencyTree>();
        for (DependencyTree child : node.getChildren()) {
            if (!this.allDependencies.contains(child)) continue;
            children.add(child);
        }
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            DependencyTree child = (DependencyTree)children.get(i);
            this.write(writer, child, this.concat(indents, i + 1 < size));
        }
    }

    private boolean[] concat(boolean[] array, boolean element) {
        boolean[] result = new boolean[array.length + 1];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        result[array.length] = element;
        return result;
    }
}

