/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.collection.UnsolvableVersionConflictException;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.util.graph.transformer.ConflictIdSorter;
import org.sonatype.aether.util.graph.transformer.TransformationContextKeys;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

public class ReplaceConflictingVersionResolver
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        Map conflictIds;
        List sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (sortedConflictIds == null) {
            ConflictIdSorter sorter = new ConflictIdSorter();
            sorter.transformGraph(node, context);
            sortedConflictIds = (List)context.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        if ((conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS)) == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        IdentityHashMap<DependencyNode, Integer> depths = new IdentityHashMap<DependencyNode, Integer>(conflictIds.size());
        for (Object key : sortedConflictIds) {
            ConflictGroup group = new ConflictGroup(key);
            depths.clear();
            this.selectVersion(node, null, 0, depths, group, conflictIds);
            this.updateNonSelectedVersions(group, conflictIds);
        }
        return node;
    }

    private void selectVersion(DependencyNode node, DependencyNode parent, int depth, Map<DependencyNode, Integer> depths, ConflictGroup group, Map<?, ?> conflictIds) throws RepositoryException {
        Integer smallestDepth = depths.get(node);
        if (smallestDepth != null && smallestDepth <= depth) {
            return;
        }
        depths.put(node, depth);
        Object key = conflictIds.get(node);
        if (group.key.equals(key)) {
            Position pos = new Position(parent, depth);
            if (parent != null) {
                group.positions.add(pos);
            }
            if (!group.isAcceptable(node.getVersion())) {
                return;
            }
            group.candidates.put(node, pos);
            VersionConstraint versionConstraint = node.getVersionConstraint();
            if (versionConstraint != null && versionConstraint.getRanges() != null && !versionConstraint.getRanges().isEmpty()) {
                group.constraints.add(versionConstraint);
            }
            if (group.version == null || this.isNearer(pos, node.getVersion(), group.position, group.version)) {
                group.version = node.getVersion();
                group.versionDependency = node;
                group.position = pos;
            }
            if (!group.isAcceptable(group.version)) {
                group.version = null;
                group.versionDependency = null;
                Iterator<Map.Entry<DependencyNode, Position>> it = group.candidates.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<DependencyNode, Position> entry = it.next();
                    Version version = entry.getKey().getVersion();
                    pos = entry.getValue();
                    if (!group.isAcceptable(version)) {
                        it.remove();
                        continue;
                    }
                    if (group.version != null && !this.isNearer(pos, version, group.position, group.version)) continue;
                    group.version = version;
                    group.versionDependency = entry.getKey();
                    group.position = pos;
                }
                if (group.version == null) {
                    LinkedHashSet<String> versions = new LinkedHashSet<String>();
                    for (VersionConstraint constraint : group.constraints) {
                        versions.add(constraint.toString());
                    }
                    throw new UnsolvableVersionConflictException(group.key, versions);
                }
            }
        }
        ++depth;
        for (DependencyNode child : node.getChildren()) {
            this.selectVersion(child, node, depth, depths, group, conflictIds);
        }
    }

    private boolean isNearer(Position pos1, Version ver1, Position pos2, Version ver2) {
        if (pos1.depth < pos2.depth) {
            return true;
        }
        return pos1.depth == pos2.depth && pos1.parent == pos2.parent && ver1.compareTo(ver2) > 0;
    }

    private void updateNonSelectedVersions(ConflictGroup group, Map<?, ?> conflictIds) {
        for (Position pos : group.positions) {
            DependencyNode parent = pos.parent;
            List<DependencyNode> children = parent.getChildren();
            ArrayList<DependencyNode> toAdd = new ArrayList<DependencyNode>();
            Iterator<DependencyNode> it = children.iterator();
            while (it.hasNext()) {
                DependencyNode child = it.next();
                Object key = conflictIds.get(child);
                if (!group.key.equals(key)) continue;
                if (!group.pruned && group.position != null && group.version != null && group.position.depth == pos.depth && group.version.equals(child.getVersion())) {
                    group.pruned = true;
                    continue;
                }
                it.remove();
                if (group.versionDependency == null) {
                    throw new IllegalStateException("Should have a versionDependency for group: " + group + " and version: " + group.version);
                }
                toAdd.add(group.versionDependency);
            }
            children.addAll(toAdd);
        }
    }

    static final class Position {
        final DependencyNode parent;
        final int depth;
        final int hash;

        public Position(DependencyNode parent, int depth) {
            this.parent = parent;
            this.depth = depth;
            this.hash = 31 * System.identityHashCode(parent) + depth;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Position)) {
                return false;
            }
            Position that = (Position)obj;
            return this.parent == that.parent && this.depth == that.depth;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.depth + " > " + this.parent;
        }
    }

    static final class ConflictGroup {
        final Object key;
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Map<DependencyNode, Position> candidates = new IdentityHashMap<DependencyNode, Position>(32);
        Version version;
        DependencyNode versionDependency;
        Position position;
        final Collection<Position> positions = new LinkedHashSet<Position>();
        boolean pruned;

        public ConflictGroup(Object key) {
            this.key = key;
            this.position = new Position(null, Integer.MAX_VALUE);
        }

        boolean isAcceptable(Version version) {
            for (VersionConstraint constraint : this.constraints) {
                if (constraint.containsVersion(version)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.key + " > " + this.version;
        }
    }
}

