/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import org.fusesource.common.util.Filter;
import org.fusesource.fabric.fab.DependencyId;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.MavenResolver;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.resolution.ArtifactResolutionException;

public class DependencyTreeResult {
    private final DependencyNode rootNode;
    private final MavenResolver resolver;
    private final Filter<Dependency> excludeDependencyFilter;
    private DependencyTree tree;

    public DependencyTreeResult(DependencyNode rootNode, MavenResolver resolver, Filter<Dependency> excludeDependencyFilter) {
        this.rootNode = rootNode;
        this.resolver = resolver;
        this.excludeDependencyFilter = excludeDependencyFilter;
    }

    public DependencyNode getRootNode() {
        return this.rootNode;
    }

    public DependencyTree getTree() throws MalformedURLException, ArtifactResolutionException {
        if (this.tree == null) {
            this.tree = DependencyTree.newInstance(this.getRootNode(), this.resolver, this.excludeDependencyFilter);
        }
        return this.tree;
    }

    public void dump(StringBuffer buffer) {
        this.displayTree(this.rootNode, "", buffer);
    }

    public String getTreeDescription() {
        StringBuffer buffer = new StringBuffer();
        this.dump(buffer);
        return buffer.toString();
    }

    protected void displayTree(DependencyNode node, String indent, StringBuffer buffer) {
        buffer.append(indent + node.getDependency()).append("\n");
        String childIndent = indent + "  ";
        for (DependencyNode child : node.getChildren()) {
            this.displayTree(child, childIndent, buffer);
        }
    }

    public void addVersions(Collection<String> versions, DependencyId artifactId) {
        this.addVersions(versions, this.rootNode, artifactId);
    }

    protected void addVersions(Collection<String> versions, DependencyNode node, DependencyId dependencyId) {
        DependencyId thatId = DependencyId.newInstance(node);
        if (dependencyId.equals(thatId)) {
            String version = ((Object)node.getVersion()).toString();
            versions.add(version);
        }
        List<DependencyNode> children = node.getChildren();
        for (DependencyNode child : children) {
            this.addVersions(versions, child, dependencyId);
        }
    }
}

