/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent.sort;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;

public class RequirementSort {
    public Collection<Resource> sort(Collection<Resource> resources) {
        LinkedHashSet<Resource> sorted = new LinkedHashSet<Resource>();
        LinkedHashSet<Resource> visited = new LinkedHashSet<Resource>();
        for (Resource r : resources) {
            this.visit(r, resources, visited, sorted);
        }
        return sorted;
    }

    private void visit(Resource resource, Collection<Resource> resources, Set<Resource> visited, Set<Resource> sorted) {
        if (visited.contains(resource)) {
            return;
        }
        visited.add(resource);
        for (Resource r : this.collectDependencies(resource, resources)) {
            this.visit(r, resources, visited, sorted);
        }
        sorted.add(resource);
    }

    private Set<Resource> collectDependencies(Resource resource, Collection<Resource> allResources) {
        Requirement[] requirements;
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        for (Requirement requirement : requirements = resource.getRequirements()) {
            boolean isSatisfied = false;
            block1: for (Resource r : result) {
                for (Capability capability : r.getCapabilities()) {
                    if (!requirement.isSatisfied(capability)) continue;
                    isSatisfied = true;
                    continue block1;
                }
            }
            block3: for (Resource r : allResources) {
                if (isSatisfied) continue;
                for (Capability capability : r.getCapabilities()) {
                    if (!requirement.isSatisfied(capability)) continue;
                    result.add(r);
                    continue block3;
                }
            }
        }
        return result;
    }
}

