/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.cryptography;

import aQute.lib.io.IO;
import aQute.libg.cryptography.Digest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Digester<T extends Digest>
extends OutputStream {
    protected MessageDigest md;

    public Digester(MessageDigest instance) {
        this.md = instance;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.md.update(buffer, offset, length);
    }

    @Override
    public void write(int b) throws IOException {
        this.md.update((byte)b);
    }

    public MessageDigest getMessageDigest() throws Exception {
        return this.md;
    }

    public T from(InputStream in) throws Exception {
        IO.copy(in, (OutputStream)this);
        return this.digest();
    }

    public abstract T digest() throws Exception;

    public abstract T digest(byte[] var1) throws Exception;

    public abstract String getAlgorithm();
}

