/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.resolver;

import aQute.bnd.resolver.Resolver;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Resource {
    final Set<Requirement> requirements = new HashSet<Requirement>();
    final Set<Capability> capabilities = new HashSet<Capability>();
    final List<Resource> fragments;
    final String bsn;
    final Version version;
    final boolean singleton;
    final Resolver resolver;

    Resource(Resolver resolver, Manifest m) {
        this.resolver = resolver;
        Attributes main = m.getMainAttributes();
        Map<String, Map<String, String>> bsns = resolver.parseHeader(main.getValue("Bundle-SymbolicName"));
        if (bsns.size() > 1) {
            resolver.error("Multiple bsns %s", bsns);
        }
        if (bsns.size() < 1) {
            resolver.error("No bsns", new Object[0]);
            this.bsn = "<not set>";
            this.version = new Version("0");
            this.singleton = false;
        } else {
            boolean attach;
            Map.Entry<String, Map<String, String>> entry = bsns.entrySet().iterator().next();
            this.bsn = entry.getKey();
            String v = main.getValue("Bundle-Version");
            this.version = this.version(v);
            this.singleton = "true".equalsIgnoreCase(entry.getValue().get("singleton:"));
            String directive = entry.getValue().get("fragment-attachment:");
            boolean bl = attach = directive == null || "always".equals(directive) || "resolve-time".equals(directive);
            if (attach) {
                this.capabilities.add(new Capability(Type.HOST, this.bsn, this.version));
            }
        }
        Map<String, Map<String, String>> hosts = resolver.parseHeader(main.getValue("Fragment-Host"));
        if (hosts.size() > 1) {
            resolver.error("Multiple fragment hosts %s", hosts);
        }
        if (hosts.size() == 1) {
            Map.Entry<String, Map<String, String>> entry = hosts.entrySet().iterator().next();
            String host = entry.getKey();
            VersionRange range = this.range(entry.getValue().get("version"));
            this.requirements.add(new Requirement(Type.HOST, host, range, false));
            this.fragments = null;
        } else {
            this.fragments = new ArrayList<Resource>();
            this.capabilities.add(new Capability(Type.BUNDLE, this.bsn, this.version));
        }
        Map<String, Map<String, String>> rbs = resolver.parseHeader(main.getValue("Require-Bundle"));
        for (Map.Entry<String, Map<String, String>> clause : rbs.entrySet()) {
            boolean optional = "optional".equals(clause.getValue().get("resolution:"));
            this.requirements.add(new Requirement(Type.BUNDLE, clause.getKey(), this.range(clause.getValue().get("version")), optional));
        }
        Map<String, Map<String, String>> imports = resolver.parseHeader(main.getValue("Import-Package"));
        for (Map.Entry<String, Map<String, String>> clause : imports.entrySet()) {
            boolean optional = "optional".equals(clause.getValue().get("resolution:"));
            this.requirements.add(new Requirement(Type.PACKAGE, clause.getKey(), this.range(clause.getValue().get("version")), optional));
        }
        Map<String, Map<String, String>> exports = resolver.parseHeader(main.getValue("Export-Package"));
        for (Map.Entry<String, Map<String, String>> clause : exports.entrySet()) {
            this.capabilities.add(new Capability(Type.PACKAGE, clause.getKey(), this.version(clause.getValue().get("version"))));
        }
    }

    private VersionRange range(String string) {
        try {
            return new VersionRange(string);
        }
        catch (NullPointerException e) {
            return new VersionRange("0");
        }
        catch (Exception e) {
            this.resolver.error("Invalid version range: %s in %s-%s", string, this.bsn, this.version);
            return new VersionRange("0");
        }
    }

    private Version version(String string) {
        try {
            return new Version(string);
        }
        catch (NullPointerException e) {
            return new Version("0");
        }
        catch (Exception e) {
            this.resolver.error("Invalid version: %s in %s-%s", string, this.bsn, this.version);
            return new Version("0");
        }
    }

    public String toString() {
        return this.bsn + "-" + this.version;
    }

    class Capability {
        final Type type;
        final String name;
        final Version version;

        Capability(Type type, String name, Version version) {
            this.type = type;
            this.name = name;
            this.version = version;
        }

        Resource getDeclaredResource() {
            return Resource.this;
        }

        public String toString() {
            return "C." + (Object)((Object)this.type) + ":" + this.name + "-" + this.version;
        }
    }

    class Requirement {
        final Type type;
        final String name;
        final VersionRange range;
        final boolean optional;

        Requirement(Type type, String name, VersionRange range, boolean optional) {
            this.type = type;
            this.name = name;
            this.range = range;
            this.optional = optional;
        }

        Resource getDeclaredResource() {
            return Resource.this;
        }

        public boolean matches(Capability cap) {
            boolean a = cap.type == this.type;
            boolean b = cap.name.equals(this.name);
            boolean c = this.range.includes(cap.version);
            return a && b && c;
        }

        public String toString() {
            return "R." + (Object)((Object)this.type) + ":" + this.name + "-" + this.range;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        PACKAGE,
        BUNDLE,
        HOST;

    }
}

