/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.resolver;

import aQute.bnd.build.Container;
import aQute.bnd.resolver.Resolution;
import aQute.bnd.resolver.Resource;
import aQute.lib.collections.MultiMap;
import aQute.lib.osgi.Processor;
import aQute.libg.generics.Create;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver
extends Processor {
    final Set<Resource> resources = new HashSet<Resource>();
    private Map<Resource.Requirement, Set<Resource>> cache = new IdentityHashMap<Resource.Requirement, Set<Resource>>();

    public void add(Container c) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        c.contributeFiles(files, this);
        for (File f : files) {
            this.add(f);
        }
    }

    public void addAll(Collection<Container> containers) throws Exception {
        for (Container c : containers) {
            this.add(c);
        }
    }

    public Resolution resolve() throws Exception {
        HashSet<Resource> active = new HashSet<Resource>();
        HashSet<Resource> fragments = new HashSet<Resource>();
        HashSet<Resource> singletons = new HashSet<Resource>();
        for (Resource r : this.resources) {
            if (r.fragments != null) {
                active.add(r);
                if (!r.singleton) continue;
                singletons.add(r);
                continue;
            }
            fragments.add(r);
        }
        for (Resource r : fragments) {
            Collection<Resource> hosts = this.find(active, r.requirements, new HashSet<Resource>());
            for (Resource host : hosts) {
                host.fragments.add(host);
            }
        }
        HashSet<Resource.Requirement> reqs = new HashSet<Resource.Requirement>();
        for (Resource r : active) {
            reqs.addAll(r.requirements);
            for (Resource f : r.fragments) {
                reqs.addAll(f.requirements);
            }
        }
        Set optional = Create.set();
        Set<Resource.Requirement> unresolved = Create.set();
        Map unique = Create.map();
        MultiMap<Resource.Requirement, Resource> multiple = new MultiMap<Resource.Requirement, Resource>();
        for (Resource.Requirement req : reqs) {
            Set<Resource> solutions = this.find(active, req, new HashSet<Resource>());
            if (solutions.isEmpty()) {
                if (req.optional) {
                    optional.add(req);
                    continue;
                }
                unresolved.add(req);
                continue;
            }
            if (solutions.size() == 1) {
                unique.put(req, solutions.iterator().next());
                continue;
            }
            multiple.addAll(req, solutions);
        }
        if (!unresolved.isEmpty()) {
            for (Resource.Requirement r : unresolved) {
                this.error("Unresolved %s", r);
            }
        }
        MultiMap<String, Resource> picked = new MultiMap<String, Resource>();
        for (Resource r : singletons) {
            picked.add(r.bsn, r);
        }
        Iterator i = picked.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (((Set)entry.getValue()).size() == 1) {
                i.remove();
                continue;
            }
            HashSet x = new HashSet((Collection)entry.getValue());
            boolean changed = x.retainAll(unique.values());
            if (x.size() > 1) {
                this.error("Singleton conflict: %s", x);
                continue;
            }
            if (!changed) continue;
            HashSet delta = new HashSet((Collection)entry.getValue());
            delta.removeAll(x);
            Iterator it = multiple.all();
            while (i.hasNext()) {
                Resource r = (Resource)it.next();
                if (!delta.contains(r)) continue;
                it.remove();
            }
        }
        Resolution res = new Resolution();
        res.multiple = multiple;
        res.unique = unique;
        res.unresolved = unresolved;
        return res;
    }

    private Collection<Resource> find(Set<Resource> active, Set<Resource.Requirement> requirements, Set<Resource> result) {
        for (Resource.Requirement req : requirements) {
            Set<Resource> resources = this.cache.get(req);
            if (resources != null) {
                result.addAll(resources);
                continue;
            }
            resources = this.find(active, req, new HashSet<Resource>());
            this.cache.put(req, resources);
            result.addAll(resources);
        }
        return result;
    }

    private Set<Resource> find(Set<Resource> active, Resource.Requirement req, Set<Resource> result) {
        for (Resource r : active) {
            for (Resource.Capability cap : r.capabilities) {
                if (cap.name.equals(req.name)) {
                    System.out.println("Yes");
                }
                if (!req.matches(cap)) continue;
                result.add(r);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file) throws IOException {
        JarFile jf = new JarFile(file);
        try {
            Manifest m = jf.getManifest();
            Resource r = new Resource(this, m);
            this.resources.add(r);
        }
        finally {
            jf.close();
        }
    }
}

