/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.agent.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fusesource.fabric.agent.utils.NullArgumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private XmlUtils() {
    }

    public static Document parseDoc(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.parseDoc(new FileInputStream(xmlFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDoc(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        try {
            BufferedInputStream in = new BufferedInputStream(is);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            return document;
        }
        finally {
            is.close();
        }
    }

    public static Element getElement(Document doc, String path) {
        NullArgumentException.validateNotNull(doc, "XML document");
        return XmlUtils.getElement(doc.getDocumentElement(), path);
    }

    public static Element getElement(Element element, String path) {
        NullArgumentException.validateNotNull(element, "Element ");
        NullArgumentException.validateNotNull(path, "Element path");
        Element current = element;
        StringTokenizer st = new StringTokenizer(path, "/", false);
        while (st.hasMoreTokens() && current != null) {
            String token = st.nextToken();
            NodeList childs = current.getChildNodes();
            current = null;
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                if (!(child instanceof Element) || !child.getNodeName().equals(token)) continue;
                current = (Element)child;
            }
        }
        return current;
    }

    public static List<Element> getElements(Document doc, String path) {
        NullArgumentException.validateNotNull(doc, "Document");
        return XmlUtils.getElements(doc.getDocumentElement(), path);
    }

    public static List<Element> getElements(Element element, String path) {
        NodeList nodeList;
        String lastElement;
        Element parent;
        NullArgumentException.validateNotNull(element, "Element");
        NullArgumentException.validateNotNull(path, "Element path");
        if (path.contains("/")) {
            parent = XmlUtils.getElement(element, path.substring(0, path.lastIndexOf("/")));
            lastElement = path.substring(path.lastIndexOf("/") + 1);
        } else {
            parent = element;
            lastElement = path;
        }
        ArrayList<Element> elements = null;
        if (parent != null && (nodeList = parent.getElementsByTagName(lastElement)) != null) {
            elements = new ArrayList<Element>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                elements.add((Element)nodeList.item(i));
            }
        }
        return elements;
    }

    public static List<Element> getChildElements(Element element) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList childs = element.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (!(child instanceof Element)) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    public static String getTextContentOfElement(Document doc, String path) {
        NullArgumentException.validateNotNull(doc, "XML document");
        return XmlUtils.getTextContentOfElement(doc.getDocumentElement(), path);
    }

    public static String getTextContentOfElement(Element element, String path) {
        NullArgumentException.validateNotNull(element, "Element");
        NullArgumentException.validateNotNull("Element path", path);
        StringTokenizer st = new StringTokenizer(path, "/", false);
        Element currentElement = element;
        while (st.hasMoreTokens()) {
            String childName = st.nextToken();
            if (childName.endsWith("]")) {
                int startPos = childName.indexOf("[");
                int endPos = childName.indexOf("]");
                NodeList children = currentElement.getElementsByTagName(childName.substring(0, startPos));
                int numChildren = children.getLength();
                String numbers = childName.substring(startPos + 1, endPos);
                int index = "last".equals(numbers) ? numChildren - 1 : Integer.parseInt(numbers);
                if (index > numChildren) {
                    throw new IllegalArgumentException("index of " + index + " is larger than the number of child nodes (" + numChildren + ")");
                }
                currentElement = (Element)children.item(index);
            } else {
                NodeList parent = currentElement.getElementsByTagName(childName);
                if (parent != null) {
                    currentElement = (Element)parent.item(0);
                }
            }
            if (null != currentElement) continue;
            return null;
        }
        return XmlUtils.getTextContent(currentElement);
    }

    public static String getTextContent(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                return XmlUtils.mergeTextContent(node.getChildNodes());
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return null;
    }

    private static String mergeTextContent(NodeList nodes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String text;
            Node n = nodes.item(i);
            switch (n.getNodeType()) {
                case 7: 
                case 8: {
                    text = null;
                    break;
                }
                default: {
                    text = XmlUtils.getTextContent(n);
                }
            }
            if (text == null) continue;
            buf.append(text);
        }
        return buf.toString();
    }
}

