/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.fusesource.fabric.zookeeper.internal.ZkUrlHandler;
import org.fusesource.fabric.zookeeper.internal.ZooKeeperAware;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class ServiceRegistrationListener
implements LifecycleListener,
ZooKeeperAware {
    private IZKClient zooKeeper;
    private String zooKeeperUrl;
    private BundleContext bundleContext;
    private ServiceRegistration clientRegistration;
    private ServiceRegistration handlerRegistration;

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public String getZooKeeperUrl() {
        return this.zooKeeperUrl;
    }

    public void setZooKeeperUrl(String zooKeeperUrl) {
        this.zooKeeperUrl = zooKeeperUrl;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void onConnected() {
        Properties props = new Properties();
        props.put("url", this.zooKeeperUrl);
        this.clientRegistration = this.bundleContext.registerService(IZKClient.class.getName(), (Object)this.zooKeeper, (Dictionary)props);
        props = new Properties();
        props.put("url", this.zooKeeperUrl);
        props.put("url.handler.protocol", "zk");
        this.handlerRegistration = this.bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new ZkUrlHandler(this.zooKeeper), (Dictionary)props);
    }

    public void onDisconnected() {
        if (this.clientRegistration != null) {
            this.clientRegistration.unregister();
        }
        if (this.handlerRegistration != null) {
            this.handlerRegistration.unregister();
        }
    }
}

