/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.fusesource.common.util.Files;
import org.fusesource.common.util.Filter;
import org.fusesource.common.util.Objects;
import org.fusesource.common.util.Strings;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.DependencyTreeFilters;
import org.fusesource.fabric.fab.FabConfiguration;
import org.fusesource.fabric.fab.MavenResolver;
import org.fusesource.fabric.fab.PomDetails;
import org.fusesource.fabric.fab.VersionedDependencyId;
import org.fusesource.fabric.fab.osgi.FabBundleInfo;
import org.fusesource.fabric.fab.osgi.FabResolver;
import org.fusesource.fabric.fab.osgi.FabResolverFactory;
import org.fusesource.fabric.fab.osgi.internal.BndUtils;
import org.fusesource.fabric.fab.osgi.internal.Configuration;
import org.fusesource.fabric.fab.osgi.internal.ConfigurationImpl;
import org.fusesource.fabric.fab.osgi.internal.FabBundleInfoImpl;
import org.fusesource.fabric.fab.osgi.internal.FabClassPathResolver;
import org.fusesource.fabric.fab.osgi.internal.FabFacade;
import org.fusesource.fabric.fab.osgi.internal.FabFacadeSupport;
import org.fusesource.fabric.fab.osgi.internal.ServiceProvider;
import org.fusesource.fabric.fab.osgi.internal.Versions;
import org.fusesource.fabric.fab.osgi.util.FeatureCollector;
import org.fusesource.fabric.fab.osgi.util.Features;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.PreConditionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.graph.Dependency;

public class FabResolverFactoryImpl
implements FabResolverFactory,
ServiceProvider {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabResolver.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configurationAdmin;
    private FeaturesService featuresService;
    private Configuration configuration;

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = ConfigurationImpl.newInstance(this.configurationAdmin, this.bundleContext);
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public FabResolver getResolver(URL url) {
        try {
            return new FabResolverImpl(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static class FeaturesMatchingFilter
    implements Filter<DependencyTree>,
    FeatureCollector {
        private final List<String> features = new LinkedList<String>();
        private final FeaturesService service;
        private final FabConfiguration configuration;
        private Filter<DependencyTree> filter;

        public FeaturesMatchingFilter(FeaturesService service, FabConfiguration configuration) {
            this.service = service;
            this.configuration = configuration;
        }

        public Collection<String> getCollection() {
            return this.features;
        }

        private Filter<DependencyTree> getDependencyTreeFilter() {
            if (this.filter == null) {
                this.filter = DependencyTreeFilters.parse(this.configuration.getStringProperty("FAB-Skip-Matching-Feature-Detection"));
            }
            return this.filter;
        }

        public boolean matches(DependencyTree dependencyTree) {
            boolean result = false;
            if (!this.getDependencyTreeFilter().matches((Object)dependencyTree)) {
                try {
                    Feature feature = Features.getFeatureForBundle(this.service.listFeatures(), dependencyTree);
                    if (feature != null) {
                        String replacement = String.format("%s/%s", feature.getName(), feature.getVersion());
                        this.features.add(replacement);
                        LOG.info(String.format("Installing feature %s for maven dependency %s/%s/%s", replacement, dependencyTree.getGroupId(), dependencyTree.getArtifactId(), dependencyTree.getVersion()));
                        result = true;
                    }
                }
                catch (Exception e) {
                    LOG.debug(String.format("Unable to retrieve features information while processing dependency %s", dependencyTree.getArtifactId()), (Throwable)e);
                }
            }
            return result;
        }
    }

    public class FabResolverImpl
    implements FabResolver,
    FabFacade {
        private final BundleContext bundleContext;
        private PomDetails pomDetails;
        private boolean includeSharedResources = true;
        private FabClassPathResolver classPathResolver;
        private Model model;
        private DependencyTree rootTree;
        private final URL url;

        public FabResolverImpl(URL url) throws MalformedURLException {
            this.url = url;
            NullArgumentException.validateNotNull((Object)url, (String)"URL");
            this.bundleContext = FabResolverFactoryImpl.this.bundleContext;
            String path = url.getPath();
            if (path == null || path.trim().length() == 0) {
                throw new MalformedURLException("Path cannot empty");
            }
        }

        @Override
        public DependencyTree collectDependencyTree(boolean offline, Filter<Dependency> excludeDependencyFilter) throws RepositoryException, IOException, XmlPullParserException {
            if (this.rootTree == null) {
                PomDetails details = this.resolvePomDetails();
                Objects.notNull((Object)details, (String)"pomDetails");
                try {
                    this.rootTree = this.getResolver().collectDependencies(details, offline, excludeDependencyFilter).getTree();
                }
                catch (IOException e) {
                    this.logFailure(e);
                    throw e;
                }
                catch (XmlPullParserException e) {
                    this.logFailure(e);
                    throw e;
                }
                catch (RepositoryException e) {
                    this.logFailure(e);
                    throw e;
                }
            }
            return this.rootTree;
        }

        public void setRootTree(DependencyTree rootTree) {
            this.rootTree = rootTree;
        }

        protected void logFailure(Exception e) {
            LOG.error(e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null && cause != e) {
                LOG.error("Caused by: " + e, (Throwable)e);
            }
        }

        @Override
        public VersionedDependencyId getVersionedDependencyId() throws IOException, XmlPullParserException {
            PomDetails pomDetails = this.resolvePomDetails();
            if (pomDetails == null || !pomDetails.isValid()) {
                LOG.warn("Cannot resolve pom.xml for " + this.getJarFile());
                return null;
            }
            this.model = pomDetails.getModel();
            return new VersionedDependencyId(this.model);
        }

        @Override
        public String getProjectDescription() {
            if (this.model != null) {
                return this.model.getDescription();
            }
            return null;
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        @Override
        public MavenResolver getResolver() {
            return this.getConfiguration().getResolver();
        }

        @Override
        public Configuration getConfiguration() {
            return FabResolverFactoryImpl.this.getConfiguration();
        }

        public PomDetails getPomDetails() {
            return this.pomDetails;
        }

        public void setPomDetails(PomDetails pomDetails) {
            this.pomDetails = pomDetails;
        }

        @Override
        public File getJarFile() throws IOException {
            return Files.urlToFile((URL)this.url, (String)"fabric-tmp-fab-", (String)".fab");
        }

        @Override
        public boolean isIncludeSharedResources() {
            return this.includeSharedResources;
        }

        public void setIncludeSharedResources(boolean includeSharedResources) {
            this.includeSharedResources = includeSharedResources;
        }

        @Override
        public PomDetails resolvePomDetails() throws IOException {
            PomDetails pomDetails = this.getPomDetails();
            if (pomDetails == null) {
                File fileJar = this.getJarFile();
                pomDetails = this.getResolver().findPomFile(fileJar);
            }
            return pomDetails;
        }

        @Override
        public FabBundleInfo getInfo() throws IOException {
            try {
                HashMap<String, Object> embeddedResources = new HashMap<String, Object>();
                Properties instructions = this.createInstructions(embeddedResources);
                PreConditionException.validateNotNull((Object)instructions, (String)"Instructions");
                String fabUri = instructions.getProperty("FAB-URL");
                if (fabUri == null || fabUri.trim().length() == 0) {
                    throw new IOException("Instructions file must contain a property named FAB-URL");
                }
                FabBundleInfoImpl info = new FabBundleInfoImpl(this.classPathResolver, fabUri, instructions, this.getConfiguration(), embeddedResources, this.resolvePomDetails());
                return info;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        protected Properties createInstructions(Map<String, Object> embeddedResources) throws IOException, RepositoryException, XmlPullParserException, BundleException {
            Properties instructions = BndUtils.parseInstructions(this.url.getQuery());
            String urlText = this.url.toExternalForm();
            instructions.setProperty("FAB-URL", urlText);
            this.configureInstructions(instructions, embeddedResources);
            return instructions;
        }

        protected void configureInstructions(Properties instructions, Map<String, Object> embeddedResources) throws RepositoryException, IOException, XmlPullParserException, BundleException {
            this.getClasspathResolver(instructions, embeddedResources).resolve();
        }

        @Override
        public String toVersionRange(String version) {
            int digits = 3;
            String value = this.classPathResolver.getManifestProperty("FAB-Version-Range-Digits");
            if (Strings.notEmpty((String)value)) {
                try {
                    digits = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Failed to parse manifest header FAB-Version-Range-Digits as a number. Got: '" + value + "' so ignoring it");
                }
                if (digits < 0 || digits > 4) {
                    LOG.warn("Invalid value of manifest header FAB-Version-Range-Digits as value " + digits + " is out of range so ignoring it");
                    digits = 3;
                }
            }
            return Versions.toVersionRange(version, digits);
        }

        @Override
        public boolean isInstalled(DependencyTree tree) {
            return FabFacadeSupport.isInstalled(this.getBundleContext(), tree);
        }

        public FabClassPathResolver getClasspathResolver(Properties instructions, Map<String, Object> embeddedResources) {
            if (this.classPathResolver == null) {
                this.classPathResolver = new FabClassPathResolver(this, instructions, embeddedResources);
                if (FabResolverFactoryImpl.this.featuresService != null) {
                    this.classPathResolver.addPruningFilter(new FeaturesMatchingFilter(FabResolverFactoryImpl.this.getFeaturesService(), this.classPathResolver));
                }
            }
            return this.classPathResolver;
        }

        public FabClassPathResolver getClassPathResolver() {
            return this.classPathResolver;
        }
    }
}

