/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.commands.fab;

import java.io.PrintStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.common.util.Strings;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.osgi.FabBundleInfo;
import org.fusesource.fabric.fab.osgi.FabResolver;
import org.fusesource.fabric.fab.osgi.commands.CommandSupport;

@Command(name="info", scope="fab", description="Display information about the features and bundles that get installed by a FAB")
public class InfoCommand
extends CommandSupport {
    @Argument(index=0, name="fab", description="The Bundle ID, URL or file of the FAB", required=true)
    private String fab;

    protected Object doExecute() throws Exception {
        FabResolver resolver = this.getFabResolver(this.fab);
        if (this.fab != null) {
            FabBundleInfo info = resolver.getInfo();
            PrintStream console = this.session.getConsole();
            console.printf("URL: %s%n", info.getUrl());
            this.printEmbedded(console, InfoCommand.getClassPathElements(info.getManifest().getValue("Bundle-ClassPath")));
            this.printBundles(console, info.getBundles());
            this.printFeatures(console, info.getFeatures());
            this.printFeatureURLs(console, info.getFeatureURLs());
            console.printf("%nFor more information about this FAB:%n", new Object[0]);
            console.printf("  use 'fab:headers %s' to view the OSGi headers%n", this.fab);
            console.printf("  use 'fab:tree %s' to view a tree representation of the dependencies%n", this.fab);
        }
        return null;
    }

    private void printEmbedded(PrintStream console, List<String> elements) {
        if (elements.size() == 0) {
            console.printf("%nNo embedded/non-shared dependencies%n", new Object[0]);
        } else {
            console.printf("%nNon-shared dependencies (embedded in FAB):%n", new Object[0]);
            for (String element : elements) {
                console.printf("    %s%n", element);
            }
        }
    }

    private void printFeatureURLs(PrintStream console, Collection<URI> uris) {
        if (uris.size() == 0) {
            console.printf("%nNo additional features repositories required%n", new Object[0]);
        } else {
            console.printf("%nAdditional features respositories:%n", new Object[0]);
            for (URI uri : uris) {
                console.printf("    %s%n", uri);
            }
        }
    }

    private void printFeatures(PrintStream console, Collection<String> features) {
        if (features.size() == 0) {
            console.printf("%nNo additional features required%n", new Object[0]);
        } else {
            console.printf("%nAdditional features:%n", new Object[0]);
            for (String feature : features) {
                console.printf("    %s%n", feature);
            }
        }
    }

    private void printBundles(PrintStream console, Collection<DependencyTree> bundles) {
        if (bundles.size() == 0) {
            console.printf("%nNo shared/bundle dependencies required%n", new Object[0]);
        } else {
            console.printf("%nShared dependencies (installed as bundles when necessary):%n", new Object[0]);
            for (DependencyTree bundle : bundles) {
                console.printf("    mvn:%s/%s/%s%n", bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion());
            }
        }
    }

    protected static List<String> getClassPathElements(String value) {
        List list = Strings.splitAndTrimAsList((String)Strings.emptyIfNull((String)value), (String)",");
        list.remove(".");
        return list;
    }
}

