/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import org.fusesource.common.util.Filter;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;

public class DependencyFilter
implements Filter<Dependency> {
    private final Filter<String> groupFilter;
    private final Filter<String> artifactFilter;

    public DependencyFilter(Filter<String> groupFilter, Filter<String> artifactFilter) {
        this.groupFilter = groupFilter;
        this.artifactFilter = artifactFilter;
    }

    public boolean matches(Dependency dependencyTree) {
        Artifact artifact = dependencyTree.getArtifact();
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        return this.groupFilter.matches((Object)groupId) && this.artifactFilter.matches((Object)artifactId);
    }

    public String toString() {
        return "DependencyFilter(" + this.groupFilter + ":" + this.artifactFilter + ")";
    }
}

