/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CompoundEnumeration<T>
implements Enumeration<T> {
    private Enumeration<T>[] enums = null;
    private int index = 0;

    public CompoundEnumeration(Enumeration<T>[] enums) {
        this.enums = enums;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.currentEnumeration() == null) {
            return false;
        }
        return this.currentEnumeration().hasMoreElements();
    }

    private Enumeration<T> findNextEnumeration(boolean moveCursor) {
        return this.findNextEnumeration(this.index, moveCursor);
    }

    private Enumeration<T> findNextEnumeration(int cursor, boolean moveCursor) {
        int next = cursor + 1;
        if (next < this.enums.length) {
            if (this.enums[next] != null && this.enums[next].hasMoreElements()) {
                if (moveCursor) {
                    this.index = next;
                }
                return this.enums[next];
            }
            return this.findNextEnumeration(next, moveCursor);
        }
        return null;
    }

    @Override
    public T nextElement() {
        if (this.currentEnumeration() != null) {
            return this.currentEnumeration().nextElement();
        }
        throw new NoSuchElementException("No more elements");
    }

    private Enumeration<T> currentEnumeration() {
        if (this.enums != null && this.index < this.enums.length) {
            Enumeration<T> e = this.enums[this.index];
            if (e == null || !e.hasMoreElements()) {
                e = this.findNextEnumeration(true);
            }
            return e;
        }
        return null;
    }
}

