/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.TextNode;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLTokenizer;

public class Comment
extends BasicNode
implements TextNode {
    private String text;

    public Comment(Token token) {
        super(token);
    }

    public Comment(String text) {
        super(XMLTokenizer.Type.COMMENT, null);
        this.setText(text);
    }

    public Comment setText(String text) {
        if (text == null || text.length() == 0) {
            text = " ";
        }
        if (text.contains("--")) {
            throw new XMLParseException("The text of a comment must not contain '--': [" + text + "]");
        }
        this.setValue("<!--" + text + "-->");
        this.text = text;
        return this;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.getValue();
            this.text = this.text.substring(4, this.text.length() - 3);
        }
        return this.text;
    }

    public Comment createClone() {
        return new Comment(this.text);
    }

    public Comment copy() {
        return (Comment)super.copy();
    }
}

