/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fusesource.fabric.stream.log.Support;

public class SnappyCompressor
implements Processor {
    @Override
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        if (in.getBody() != null) {
            byte[] data = in.getMandatoryBody(byte[].class);
            byte[] compressed = Support.compress(data);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getOut();
                out.copyFrom(in);
                out.setBody(compressed);
            } else {
                in.setBody(compressed);
            }
        }
    }
}

