/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered,
EmbeddedValueResolverAware,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private Object scheduler;
    private StringValueResolver embeddedValueResolver;
    private ApplicationContext applicationContext;
    private ScheduledTaskRegistrar registrar;
    private final Map<Runnable, String> cronTasks = new HashMap<Runnable, String>();
    private final Map<Runnable, Long> fixedDelayTasks = new HashMap<Runnable, Long>();
    private final Map<Runnable, Long> fixedRateTasks = new HashMap<Runnable, Long>();

    public void setScheduler(Object scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(final Object bean, String beanName) {
        final Class<?> targetClass = AopUtils.getTargetClass(bean);
        ReflectionUtils.doWithMethods(targetClass, new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Scheduled annotation = AnnotationUtils.getAnnotation(method, Scheduled.class);
                if (annotation != null) {
                    long fixedRate;
                    long fixedDelay;
                    Assert.isTrue(Void.TYPE.equals(method.getReturnType()), "Only void-returning methods may be annotated with @Scheduled.");
                    Assert.isTrue(method.getParameterTypes().length == 0, "Only no-arg methods may be annotated with @Scheduled.");
                    if (AopUtils.isJdkDynamicProxy(bean)) {
                        try {
                            method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                        }
                        catch (SecurityException ex) {
                            ReflectionUtils.handleReflectionException(ex);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new IllegalStateException(String.format("@Scheduled method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), targetClass.getSimpleName()));
                        }
                    }
                    ScheduledMethodRunnable runnable = new ScheduledMethodRunnable(bean, method);
                    boolean processedSchedule = false;
                    String errorMessage = "Exactly one of 'cron', 'fixedDelay', or 'fixedRate' is required.";
                    String cron = annotation.cron();
                    if (!"".equals(cron)) {
                        processedSchedule = true;
                        if (ScheduledAnnotationBeanPostProcessor.this.embeddedValueResolver != null) {
                            cron = ScheduledAnnotationBeanPostProcessor.this.embeddedValueResolver.resolveStringValue(cron);
                        }
                        ScheduledAnnotationBeanPostProcessor.this.cronTasks.put(runnable, cron);
                    }
                    if ((fixedDelay = annotation.fixedDelay()) >= 0L) {
                        Assert.isTrue(!processedSchedule, errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedDelayTasks.put(runnable, fixedDelay);
                    }
                    if ((fixedRate = annotation.fixedRate()) >= 0L) {
                        Assert.isTrue(!processedSchedule, errorMessage);
                        processedSchedule = true;
                        ScheduledAnnotationBeanPostProcessor.this.fixedRateTasks.put(runnable, fixedRate);
                    }
                    Assert.isTrue(processedSchedule, errorMessage);
                }
            }
        });
        return bean;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() != this.applicationContext) {
            return;
        }
        Map<String, SchedulingConfigurer> configurers = this.applicationContext.getBeansOfType(SchedulingConfigurer.class);
        if (this.cronTasks.isEmpty() && this.fixedDelayTasks.isEmpty() && this.fixedRateTasks.isEmpty() && configurers.isEmpty()) {
            return;
        }
        this.registrar = new ScheduledTaskRegistrar();
        this.registrar.setCronTasks(this.cronTasks);
        this.registrar.setFixedDelayTasks(this.fixedDelayTasks);
        this.registrar.setFixedRateTasks(this.fixedRateTasks);
        if (this.scheduler != null) {
            this.registrar.setScheduler(this.scheduler);
        }
        for (SchedulingConfigurer configurer : configurers.values()) {
            configurer.configureTasks(this.registrar);
        }
        if (this.registrar.getScheduler() == null) {
            HashMap<String, Object> schedulers = new HashMap<String, Object>();
            schedulers.putAll(this.applicationContext.getBeansOfType(TaskScheduler.class));
            schedulers.putAll(this.applicationContext.getBeansOfType(ScheduledExecutorService.class));
            if (schedulers.size() != 0) {
                if (schedulers.size() == 1) {
                    this.registrar.setScheduler(schedulers.values().iterator().next());
                } else if (schedulers.size() >= 2) {
                    throw new IllegalStateException("More than one TaskScheduler and/or ScheduledExecutorService  exist within the context. Remove all but one of the beans; or implement the SchedulingConfigurer interface and call ScheduledTaskRegistrar#setScheduler explicitly within the configureTasks() callback. Found the following beans: " + schedulers.keySet());
                }
            }
        }
        this.registrar.afterPropertiesSet();
    }

    @Override
    public void destroy() throws Exception {
        if (this.registrar != null) {
            this.registrar.destroy();
        }
    }
}

