/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.PropertyPlaceholderHelper;

public class BridgePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements PropertiesResolver,
AugmentedPropertyNameAwarePropertiesParser {
    private final Properties properties = new Properties();
    private PropertiesResolver resolver;
    private PropertiesParser parser;
    private String id;
    private PropertyPlaceholderHelper helper;
    private String configuredPlaceholderPrefix;
    private String configuredPlaceholderSuffix;
    private String configuredValueSeparator;
    private Boolean configuredIgnoreUnresolvablePlaceholders;

    @Override
    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.properties.putAll((Map<?, ?>)props);
        this.helper = new PropertyPlaceholderHelper(this.configuredPlaceholderPrefix != null ? this.configuredPlaceholderPrefix : "${", this.configuredPlaceholderSuffix != null ? this.configuredPlaceholderSuffix : "}", this.configuredValueSeparator != null ? this.configuredValueSeparator : ":", this.configuredIgnoreUnresolvablePlaceholders != null ? this.configuredIgnoreUnresolvablePlaceholders : false);
    }

    @Override
    public void setBeanName(String beanName) {
        this.id = beanName;
        super.setBeanName(beanName);
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        super.setPlaceholderPrefix(placeholderPrefix);
        this.configuredPlaceholderPrefix = placeholderPrefix;
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        super.setPlaceholderSuffix(placeholderSuffix);
        this.configuredPlaceholderSuffix = placeholderSuffix;
    }

    @Override
    public void setValueSeparator(String valueSeparator) {
        super.setValueSeparator(valueSeparator);
        this.configuredValueSeparator = valueSeparator;
    }

    @Override
    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        super.setIgnoreUnresolvablePlaceholders(ignoreUnresolvablePlaceholders);
        this.configuredIgnoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    @Override
    public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, String ... uri) throws Exception {
        Properties answer = new Properties();
        for (String u : uri) {
            Properties p;
            String ref = "ref:" + this.id;
            if (ref.equals(u)) {
                answer.putAll((Map<?, ?>)this.properties);
                continue;
            }
            if (this.resolver == null || (p = this.resolver.resolveProperties(context, ignoreMissingLocation, u)) == null) continue;
            answer.putAll((Map<?, ?>)p);
        }
        return answer;
    }

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken, String propertyPrefix, String propertySuffix, boolean fallbackToUnaugmentedProperty) throws IllegalArgumentException {
        String answer = this.parser instanceof AugmentedPropertyNameAwarePropertiesParser ? ((AugmentedPropertyNameAwarePropertiesParser)this.parser).parseUri(text, properties, prefixToken, suffixToken, propertyPrefix, propertySuffix, fallbackToUnaugmentedProperty) : this.parser.parseUri(text, properties, prefixToken, suffixToken);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(text, properties);
        return answer;
    }

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        String answer = this.parser.parseUri(text, properties, prefixToken, suffixToken);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(text, properties);
        return answer;
    }

    @Override
    public String parseProperty(String key, String value, Properties properties) {
        String answer = this.parser.parseProperty(key, value, properties);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(value, properties);
        return answer;
    }

    protected String springResolvePlaceholders(String text, Properties properties) {
        return this.helper.replacePlaceholders(text, properties);
    }

    public void setResolver(PropertiesResolver resolver) {
        this.resolver = resolver;
    }

    public void setParser(PropertiesParser parser) {
        this.parser = parser;
    }
}

