/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.BytesSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.StringSource;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.converter.jaxp.XmlErrorListener;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Converter
public class XmlConverter {
    @Deprecated
    public static final String DEFAULT_CHARSET_PROPERTY = "org.apache.camel.default.charset";
    public static final String OUTPUT_PROPERTIES_PREFIX = "org.apache.camel.xmlconverter.output.";
    public static final String DOCUMENT_BUILDER_FACTORY_FEATURE = "org.apache.camel.xmlconverter.documentBuilderFactory.feature";
    public static String defaultCharset = ObjectHelper.getSystemProperty("org.apache.camel.default.charset", "UTF-8");
    private static final Logger LOG = LoggerFactory.getLogger(XPathBuilder.class);
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;

    public XmlConverter() {
    }

    public XmlConverter(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public Properties defaultOutputProperties() {
        Properties properties = new Properties();
        properties.put("encoding", defaultCharset);
        properties.put("omit-xml-declaration", "yes");
        return properties;
    }

    public void toResult(Source source, Result result) throws TransformerException {
        this.toResult(source, result, this.defaultOutputProperties());
    }

    public void toResult(Source source, Result result, Properties outputProperties) throws TransformerException {
        if (source == null) {
            return;
        }
        Transformer transformer = this.createTransformer();
        if (transformer == null) {
            throw new TransformerException("Could not create a transformer - JAXP is misconfigured!");
        }
        transformer.setOutputProperties(outputProperties);
        transformer.transform(source, result);
    }

    @Converter
    public Boolean toBoolean(NodeList list) {
        return list.getLength() > 0;
    }

    @Converter
    public BytesSource toBytesSource(byte[] data) {
        return new BytesSource(data);
    }

    @Converter
    public StringSource toStringSource(String data) {
        return new StringSource(data);
    }

    @Deprecated
    public DOMSource toSource(Document document) {
        return new DOMSource(document);
    }

    @Deprecated
    public Source toSource(Node node) throws ParserConfigurationException, TransformerException {
        return this.toDOMSource(node);
    }

    @Converter
    public DOMSource toDOMSource(Node node) throws ParserConfigurationException, TransformerException {
        Document document = this.toDOMDocument(node);
        return new DOMSource(document);
    }

    @Converter
    public DOMSource toDOMSource(Document document) {
        return new DOMSource(document);
    }

    @Converter
    public Source toSource(String data) {
        return new StringSource(data);
    }

    @Deprecated
    public String toString(Source source) throws TransformerException {
        return this.toString(source, null);
    }

    @Converter
    public String toString(Source source, Exchange exchange) throws TransformerException {
        Properties properties;
        if (source == null) {
            return null;
        }
        if (source instanceof StringSource) {
            return ((StringSource)source).getText();
        }
        if (source instanceof BytesSource) {
            return new String(((BytesSource)source).getData());
        }
        StringWriter buffer = new StringWriter();
        if (exchange != null && (properties = ObjectHelper.getCamelPropertiesWithPrefix(OUTPUT_PROPERTIES_PREFIX, exchange.getContext())).size() > 0) {
            this.toResult(source, new StreamResult(buffer), properties);
            return buffer.toString();
        }
        this.toResult(source, new StreamResult(buffer));
        return buffer.toString();
    }

    @Converter
    public byte[] toByteArray(Source source, Exchange exchange) throws TransformerException {
        String answer = this.toString(source, exchange);
        if (exchange != null) {
            return exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, answer);
        }
        return answer.getBytes();
    }

    @Deprecated
    public String toString(Node node) throws TransformerException {
        return this.toString(node, null);
    }

    @Converter
    public String toString(Node node, Exchange exchange) throws TransformerException {
        return this.toString(new DOMSource(node), exchange);
    }

    @Converter
    public DOMSource toDOMSource(Source source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        if (source instanceof DOMSource) {
            return (DOMSource)source;
        }
        if (source instanceof SAXSource) {
            return this.toDOMSourceFromSAX((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.toDOMSourceFromStream((StreamSource)source);
        }
        if (source instanceof StAXSource) {
            return this.toDOMSourceFromStAX((StAXSource)source);
        }
        return null;
    }

    @Converter
    public DOMSource toDOMSource(String text) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        Source source = this.toSource(text);
        if (source != null) {
            return this.toDOMSourceFromStream((StreamSource)source);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public DOMSource toDOMSource(byte[] bytes) throws IOException, SAXException, ParserConfigurationException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            DOMSource dOMSource = this.toDOMSource(is);
            return dOMSource;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    @Deprecated
    public SAXSource toSAXSource(String source) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(source, null);
    }

    @Converter
    public SAXSource toSAXSource(String source, Exchange exchange) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toSource(source), exchange);
    }

    @Converter
    public StAXSource toStAXSource(String source, Exchange exchange) throws XMLStreamException {
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(new StringReader(source));
        return new StAXSource(r);
    }

    @Converter
    public StAXSource toStAXSource(byte[] in, Exchange exchange) throws XMLStreamException {
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(new ByteArrayInputStream(in), exchange);
        return new StAXSource(r);
    }

    @Deprecated
    public SAXSource toSAXSource(InputStream source) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(source, null);
    }

    @Converter
    public SAXSource toSAXSource(InputStream source, Exchange exchange) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toStreamSource(source), exchange);
    }

    @Converter
    public SAXSource toSAXSource(byte[] in, Exchange exchange) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(this.toStreamSource(in, exchange), exchange);
    }

    @Converter
    public StAXSource toStAXSource(InputStream source, Exchange exchange) throws XMLStreamException {
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(source, exchange);
        return new StAXSource(r);
    }

    @Converter
    public SAXSource toSAXSource(File file, Exchange exchange) throws IOException, SAXException, TransformerException {
        BufferedInputStream is = IOHelper.buffered(new FileInputStream(file));
        return this.toSAXSource(is, exchange);
    }

    @Converter
    public StAXSource toStAXSource(File file, Exchange exchange) throws FileNotFoundException, XMLStreamException {
        BufferedInputStream is = IOHelper.buffered(new FileInputStream(file));
        XMLStreamReader r = new StaxConverter().createXMLStreamReader(is, exchange);
        return new StAXSource(r);
    }

    @Deprecated
    public SAXSource toSAXSource(Source source) throws IOException, SAXException, TransformerException {
        return this.toSAXSource(source, null);
    }

    @Converter
    public SAXSource toSAXSource(Source source, Exchange exchange) throws IOException, SAXException, TransformerException {
        if (source instanceof SAXSource) {
            return (SAXSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toSAXSourceFromDOM((DOMSource)source, exchange);
        }
        if (source instanceof StreamSource) {
            return this.toSAXSourceFromStream((StreamSource)source);
        }
        if (source instanceof StAXSource) {
            return this.toSAXSourceFromStAX((StAXSource)source, exchange);
        }
        return null;
    }

    @Deprecated
    public StreamSource toStreamSource(Source source) throws TransformerException {
        return this.toStreamSource(source, null);
    }

    @Converter
    public StreamSource toStreamSource(Source source, Exchange exchange) throws TransformerException {
        if (source instanceof StreamSource) {
            return (StreamSource)source;
        }
        if (source instanceof DOMSource) {
            return this.toStreamSourceFromDOM((DOMSource)source, exchange);
        }
        if (source instanceof SAXSource) {
            return this.toStreamSourceFromSAX((SAXSource)source, exchange);
        }
        if (source instanceof StAXSource) {
            return this.toStreamSourceFromStAX((StAXSource)source, exchange);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(InputStream in) throws TransformerException {
        if (in != null) {
            return new StreamSource(in);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(Reader in) throws TransformerException {
        if (in != null) {
            return new StreamSource(in);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(File in) throws TransformerException {
        if (in != null) {
            return new StreamSource(in);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(byte[] in, Exchange exchange) throws TransformerException {
        if (in != null) {
            InputStream is = exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, in);
            return new StreamSource(is);
        }
        return null;
    }

    @Converter
    public StreamSource toStreamSource(ByteBuffer in, Exchange exchange) throws TransformerException {
        if (in != null) {
            InputStream is = exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, in);
            return new StreamSource(is);
        }
        return null;
    }

    @Deprecated
    public StreamSource toStreamSourceFromSAX(SAXSource source) throws TransformerException {
        return this.toStreamSourceFromSAX(source, null);
    }

    @Converter
    public StreamSource toStreamSourceFromSAX(SAXSource source, Exchange exchange) throws TransformerException {
        InputSource inputSource = source.getInputSource();
        if (inputSource != null) {
            if (inputSource.getCharacterStream() != null) {
                return new StreamSource(inputSource.getCharacterStream());
            }
            if (inputSource.getByteStream() != null) {
                return new StreamSource(inputSource.getByteStream());
            }
        }
        String result = this.toString(source, exchange);
        return new StringSource(result);
    }

    @Deprecated
    public StreamSource toStreamSourceFromDOM(DOMSource source) throws TransformerException {
        return this.toStreamSourceFromDOM(source, null);
    }

    @Converter
    public StreamSource toStreamSourceFromDOM(DOMSource source, Exchange exchange) throws TransformerException {
        String result = this.toString(source, exchange);
        return new StringSource(result);
    }

    @Converter
    public StreamSource toStreamSourceFromStAX(StAXSource source, Exchange exchange) throws TransformerException {
        String result = this.toString(source, exchange);
        return new StringSource(result);
    }

    @Converter
    public SAXSource toSAXSourceFromStream(StreamSource source) {
        InputSource inputSource = source.getReader() != null ? new InputSource(source.getReader()) : new InputSource(source.getInputStream());
        inputSource.setSystemId(source.getSystemId());
        inputSource.setPublicId(source.getPublicId());
        return new SAXSource(inputSource);
    }

    @Deprecated
    public Reader toReaderFromSource(Source src) throws TransformerException {
        return this.toReaderFromSource(src, null);
    }

    @Converter
    public Reader toReaderFromSource(Source src, Exchange exchange) throws TransformerException {
        StreamSource stSrc = this.toStreamSource(src, exchange);
        Reader r = stSrc.getReader();
        if (r == null) {
            r = new InputStreamReader(stSrc.getInputStream());
        }
        return r;
    }

    @Converter
    public DOMSource toDOMSource(InputStream is) throws ParserConfigurationException, IOException, SAXException {
        InputSource source = new InputSource(is);
        String systemId = source.getSystemId();
        DocumentBuilder builder = this.createDocumentBuilder();
        Document document = builder.parse(source);
        return new DOMSource(document, systemId);
    }

    @Converter
    public DOMSource toDOMSource(File file) throws ParserConfigurationException, IOException, SAXException {
        BufferedInputStream is = IOHelper.buffered(new FileInputStream(file));
        return this.toDOMSource(is);
    }

    @Converter
    public DOMSource toDOMSourceFromStream(StreamSource source) throws ParserConfigurationException, IOException, SAXException {
        Document document;
        String systemId = source.getSystemId();
        DocumentBuilder builder = this.createDocumentBuilder();
        Reader reader = source.getReader();
        if (reader != null) {
            document = builder.parse(new InputSource(reader));
        } else {
            InputStream inputStream = source.getInputStream();
            if (inputStream != null) {
                InputSource inputsource = new InputSource(inputStream);
                inputsource.setSystemId(systemId);
                document = builder.parse(inputsource);
            } else {
                throw new IOException("No input stream or reader available on StreamSource: " + source);
            }
        }
        return new DOMSource(document, systemId);
    }

    @Deprecated
    public SAXSource toSAXSourceFromDOM(DOMSource source) throws TransformerException {
        return this.toSAXSourceFromDOM(source, null);
    }

    @Converter
    public SAXSource toSAXSourceFromDOM(DOMSource source, Exchange exchange) throws TransformerException {
        String str = this.toString(source, exchange);
        StringReader reader = new StringReader(str);
        return new SAXSource(new InputSource(reader));
    }

    @Converter
    public SAXSource toSAXSourceFromStAX(StAXSource source, Exchange exchange) throws TransformerException {
        String str = this.toString(source, exchange);
        StringReader reader = new StringReader(str);
        return new SAXSource(new InputSource(reader));
    }

    @Converter
    public DOMSource toDOMSourceFromSAX(SAXSource source) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return new DOMSource(this.toDOMNodeFromSAX(source));
    }

    @Converter
    public DOMSource toDOMSourceFromStAX(StAXSource source) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return new DOMSource(this.toDOMNodeFromStAX(source));
    }

    @Converter
    public Node toDOMNodeFromSAX(SAXSource source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DOMResult result = new DOMResult();
        this.toResult(source, result);
        return result.getNode();
    }

    @Converter
    public Node toDOMNodeFromStAX(StAXSource source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DOMResult result = new DOMResult();
        this.toResult(source, result);
        return result.getNode();
    }

    @Converter
    public Node toDOMNodeFromSingleNodeList(NodeList nl) {
        return nl.getLength() == 1 ? nl.item(0) : null;
    }

    @Converter
    public Document toDOMDocumentFromSingleNodeList(NodeList nl) throws ParserConfigurationException, TransformerException {
        return nl.getLength() == 1 ? this.toDOMDocument(nl.item(0)) : null;
    }

    @Converter
    public Node toDOMNode(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        DOMSource domSrc = this.toDOMSource(source);
        return domSrc != null ? domSrc.getNode() : null;
    }

    @Converter
    public Element toDOMElement(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        return this.toDOMElement(node);
    }

    @Converter
    public Element toDOMElement(Node node) throws TransformerException {
        if (node instanceof Document) {
            return ((Document)node).getDocumentElement();
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        throw new TransformerException("Unable to convert DOM node to an Element");
    }

    @Converter
    public Document toDOMDocument(byte[] data) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(data));
    }

    @Converter
    public Document toDOMDocument(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(in);
    }

    @Converter
    public Document toDOMDocument(Reader in) throws IOException, SAXException, ParserConfigurationException {
        return this.toDOMDocument(new InputSource(in));
    }

    @Converter
    public Document toDOMDocument(InputSource in) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(in);
    }

    @Converter
    public Document toDOMDocument(String text) throws IOException, SAXException, ParserConfigurationException {
        return this.toDOMDocument(new StringReader(text));
    }

    @Converter
    public Document toDOMDocument(File file) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    @Converter
    public Document toDOMDocument(Source source) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        Node node = this.toDOMNode(source);
        return this.toDOMDocument(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public Document toDOMDocument(Node node) throws ParserConfigurationException, TransformerException {
        ObjectHelper.notNull(node, "node");
        if (node instanceof Document) {
            return (Document)node;
        }
        if (node instanceof Element) {
            Element elem = (Element)node;
            if (elem.getOwnerDocument().getDocumentElement() == elem) {
                return elem.getOwnerDocument();
            }
            Document doc = this.createDocument();
            Document document = node.getOwnerDocument();
            synchronized (document) {
                doc.appendChild(doc.importNode(node, true));
            }
            return doc;
        }
        throw new TransformerException("Unable to convert DOM node to a Document: " + node);
    }

    @Deprecated
    public InputStream toInputStream(DOMSource source) throws TransformerException, IOException {
        return this.toInputStream(source, null);
    }

    @Converter
    public InputStream toInputStream(DOMSource source, Exchange exchange) throws TransformerException, IOException {
        String s = this.toString(source, exchange);
        return new ByteArrayInputStream(s.getBytes());
    }

    @Deprecated
    public InputStream toInputStream(Document dom) throws TransformerException, IOException {
        return this.toInputStream(dom, null);
    }

    @Converter
    public InputStream toInputStream(Document dom, Exchange exchange) throws TransformerException, IOException {
        String s = this.toString(dom, exchange);
        return new ByteArrayInputStream(s.getBytes());
    }

    @Converter
    public InputSource toInputSource(InputStream is, Exchange exchange) {
        return new InputSource(is);
    }

    @Converter
    public InputSource toInputSource(File file, Exchange exchange) throws FileNotFoundException {
        BufferedInputStream is = IOHelper.buffered(new FileInputStream(file));
        return new InputSource(is);
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.createDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    protected void setupFeatures(DocumentBuilderFactory factory) {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            String key = (String)prop.getKey();
            if (!key.startsWith(DOCUMENT_BUILDER_FACTORY_FEATURE)) continue;
            String uri = ObjectHelper.after(key, ":");
            Boolean value = Boolean.valueOf((String)prop.getValue());
            try {
                factory.setFeature(uri, value);
            }
            catch (ParserConfigurationException e) {
                LOG.warn("DocumentBuilderFactory doesn't support the feature {0} with value {1}, due to {2}.", new Object[]{uri, value, e});
            }
        }
    }

    public DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        this.setupFeatures(factory);
        return factory;
    }

    public DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory();
        return factory.newDocumentBuilder();
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.newDocument();
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    @Deprecated
    public Transformer createTransfomer() throws TransformerConfigurationException {
        return this.createTransformer();
    }

    public Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = this.getTransformerFactory();
        return factory.newTransformer();
    }

    public TransformerFactory createTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setErrorListener(new XmlErrorListener());
        return factory;
    }
}

