/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.model.ModelChannel;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.InterceptorToAsyncProcessorBridge;
import org.apache.camel.processor.RouteContextProcessor;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedComparator;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannel
extends ServiceSupport
implements ModelChannel {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultChannel.class);
    private final List<InterceptStrategy> interceptors = new ArrayList<InterceptStrategy>();
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private ProcessorDefinition<?> definition;
    private ProcessorDefinition<?> childDefinition;
    private CamelContext camelContext;
    private RouteContext routeContext;
    private RouteContextProcessor routeContextProcessor;

    @Override
    public List<Processor> next() {
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    @Override
    public void setNextProcessor(Processor next) {
        this.nextProcessor = next;
    }

    @Override
    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    @Override
    public void setOutput(Processor output) {
        this.output = output;
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    public boolean hasInterceptorStrategy(Class<?> type) {
        for (InterceptStrategy strategy : this.interceptors) {
            if (!type.isInstance(strategy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptors.add(strategy);
    }

    @Override
    public void addInterceptStrategies(List<InterceptStrategy> strategies) {
        this.interceptors.addAll(strategies);
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptors;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition() {
        return this.definition;
    }

    @Override
    public void setChildDefinition(ProcessorDefinition<?> childDefinition) {
        this.childDefinition = childDefinition;
    }

    @Override
    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    @Override
    protected void doStart() throws Exception {
        this.routeContextProcessor = new RouteContextProcessor(this.routeContext, this.getOutput());
        ServiceHelper.startServices(this.errorHandler, this.output, this.routeContextProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.output, this.errorHandler, this.routeContextProcessor);
    }

    @Override
    public void initChannel(ProcessorDefinition<?> outputDefinition, RouteContext routeContext) throws Exception {
        Processor next;
        InterceptStrategy managed;
        this.routeContext = routeContext;
        this.definition = outputDefinition;
        this.camelContext = routeContext.getCamelContext();
        Processor target = this.nextProcessor;
        if (target instanceof CamelContextAware) {
            ((CamelContextAware)((Object)target)).setCamelContext(this.camelContext);
        }
        ProcessorDefinition<?> targetOutputDef = this.childDefinition != null ? this.childDefinition : outputDefinition;
        LOG.debug("Initialize channel for target: '{}'", targetOutputDef);
        if (this.childDefinition != null && outputDefinition != this.childDefinition) {
            this.childDefinition.setParent(outputDefinition);
        }
        if ((managed = routeContext.getManagedInterceptStrategy()) != null) {
            next = target == this.nextProcessor ? null : this.nextProcessor;
            target = managed.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, next);
        }
        TraceInterceptor trace = (TraceInterceptor)this.getOrCreateTracer().wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, null);
        trace.setRouteContext(routeContext);
        target = trace;
        Collections.sort(this.interceptors, new OrderedComparator());
        Collections.reverse(this.interceptors);
        for (InterceptStrategy strategy : this.interceptors) {
            Processor processor = next = target == this.nextProcessor ? null : this.nextProcessor;
            if (strategy instanceof Tracer || strategy instanceof StreamCaching) continue;
            Processor wrapped = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, next);
            if (!(wrapped instanceof AsyncProcessor)) {
                LOG.warn("Interceptor: " + strategy + " at: " + outputDefinition + " does not return an AsyncProcessor instance." + " This causes the asynchronous routing engine to not work as optimal as possible." + " See more details at the InterceptStrategy javadoc." + " Camel will use a bridge to adapt the interceptor to the asynchronous routing engine," + " but its not the most optimal solution. Please consider changing your interceptor to comply.");
                InterceptorToAsyncProcessorBridge bridge = new InterceptorToAsyncProcessorBridge(target);
                wrapped = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, bridge, next);
                bridge.setTarget(wrapped);
                wrapped = bridge;
            }
            if (!(wrapped instanceof WrapProcessor)) {
                wrapped = new WrapProcessor(wrapped, target);
            }
            target = wrapped;
        }
        this.output = target;
    }

    @Override
    public void postInitChannel(ProcessorDefinition<?> outputDefinition, RouteContext routeContext) throws Exception {
        for (InterceptStrategy strategy : this.interceptors) {
            if (!(strategy instanceof StreamCaching)) continue;
            if (this.errorHandler != null) {
                this.errorHandler = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), outputDefinition, this.errorHandler, null);
                break;
            }
            this.output = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), outputDefinition, this.output, null);
            break;
        }
    }

    private InterceptStrategy getOrCreateTracer() {
        InterceptStrategy tracer = Tracer.getTracer(this.camelContext);
        if (tracer == null) {
            Map<String, Tracer> map;
            if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().lookupByType(Tracer.class)).size() == 1) {
                tracer = map.values().iterator().next();
            }
            if (tracer == null) {
                tracer = this.camelContext.getDefaultTracer();
                Map<String, TraceFormatter> formatters = this.camelContext.getRegistry().lookupByType(TraceFormatter.class);
                if (formatters.size() == 1) {
                    TraceFormatter formatter = formatters.values().iterator().next();
                    if (tracer instanceof Tracer) {
                        ((Tracer)tracer).setFormatter(formatter);
                    }
                }
            }
        }
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            if (!(tracer instanceof Service)) continue;
            strategy.onServiceAdd(this.camelContext, (Service)((Object)tracer), null);
        }
        return tracer;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Processor processor = this.getOutput();
        if (processor == null || !this.continueProcessing(exchange)) {
            callback.done(true);
            return true;
        }
        ObjectHelper.notNull(this.routeContextProcessor, "RouteContextProcessor", this);
        return this.routeContextProcessor.process(exchange, callback);
    }

    protected boolean continueProcessing(Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop).booleanValue())) {
            LOG.debug("Exchange is marked to stop routing: {}", exchange);
            return false;
        }
        boolean forceShutdown = this.camelContext.getShutdownStrategy().forceShutdown(this);
        if (forceShutdown) {
            LOG.debug("Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: {}", exchange);
            if (exchange.getException() == null) {
                exchange.setException(new RejectedExecutionException());
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

