/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

public final class ProcessorDefinitionHelper {
    private ProcessorDefinitionHelper() {
    }

    public static <T> Iterator<T> filterTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found);
        return found.iterator();
    }

    public static <T> T findFirstTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found);
        if (found.isEmpty()) {
            return null;
        }
        return (T)found.iterator().next();
    }

    public static boolean isFirstChildOfType(Class<?> parentType, ProcessorDefinition<?> node) {
        if (node == null || node.getParent() == null) {
            return false;
        }
        if (node.getParent().getOutputs().isEmpty()) {
            return false;
        }
        if (!node.getParent().getClass().equals(parentType)) {
            return false;
        }
        return node.getParent().getOutputs().get(0).equals(node);
    }

    public static boolean isParentOfType(Class<?> parentType, ProcessorDefinition<?> node, boolean recursive) {
        if (node == null || node.getParent() == null) {
            return false;
        }
        if (parentType.isAssignableFrom(node.getParent().getClass())) {
            return true;
        }
        if (recursive) {
            return ProcessorDefinitionHelper.isParentOfType(parentType, node.getParent(), true);
        }
        return false;
    }

    public static RouteDefinition getRoute(ProcessorDefinition<?> node) {
        ProcessorDefinition<?> def;
        if (node == null) {
            return null;
        }
        for (def = node; def != null && def.getParent() != null; def = def.getParent()) {
        }
        if (def instanceof RouteDefinition) {
            return (RouteDefinition)def;
        }
        return null;
    }

    private static <T> void doFindType(List<ProcessorDefinition<?>> outputs, Class<T> type, List<T> found) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        for (ProcessorDefinition<?> out : outputs) {
            List<ProcessorDefinition<?>> children;
            if (type.isInstance(out)) {
                found.add(out);
            }
            if (out instanceof SendDefinition) {
                SendDefinition send = (SendDefinition)out;
                children = send.getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found);
            }
            if (out instanceof ChoiceDefinition) {
                ChoiceDefinition choice = (ChoiceDefinition)out;
                for (WhenDefinition when : choice.getWhenClauses()) {
                    List<ProcessorDefinition<?>> children2 = when.getOutputs();
                    ProcessorDefinitionHelper.doFindType(children2, type, found);
                }
                if (choice.getOtherwise() != null) {
                    children = choice.getOtherwise().getOutputs();
                    ProcessorDefinitionHelper.doFindType(children, type, found);
                }
            }
            List<ProcessorDefinition<?>> children3 = out.getOutputs();
            ProcessorDefinitionHelper.doFindType(children3, type, found);
        }
    }

    public static boolean hasOutputs(List<ProcessorDefinition<?>> outputs, boolean excludeAbstract) {
        if (outputs == null || outputs.isEmpty()) {
            return false;
        }
        if (!excludeAbstract) {
            return !outputs.isEmpty();
        }
        for (ProcessorDefinition<?> output : outputs) {
            if (output instanceof TransactedDefinition || output instanceof PolicyDefinition) {
                return ProcessorDefinitionHelper.hasOutputs(output.getOutputs(), excludeAbstract);
            }
            if (output.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static boolean willCreateNewThreadPool(RouteContext routeContext, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return false;
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = routeContext.getCamelContext().getRegistry().lookup(definition.getExecutorServiceRef(), ExecutorService.class);
            return answer == null;
        }
        return useDefault;
    }

    public static ExecutorService lookupExecutorServiceRef(RouteContext routeContext, String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ExecutorService answer = routeContext.getCamelContext().getRegistry().lookup(executorServiceRef, ExecutorService.class);
        if (answer == null) {
            answer = manager.newThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public static ExecutorService getConfiguredExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return definition.getExecutorService();
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = ProcessorDefinitionHelper.lookupExecutorServiceRef(routeContext, name, definition, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultThreadPool(definition, name);
        }
        return null;
    }

    public static ScheduledExecutorService lookupScheduledExecutorServiceRef(RouteContext routeContext, String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ScheduledExecutorService answer = routeContext.getCamelContext().getRegistry().lookup(executorServiceRef, ScheduledExecutorService.class);
        if (answer == null) {
            answer = manager.newScheduledThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public static ScheduledExecutorService getConfiguredScheduledExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            ExecutorService executorService = definition.getExecutorService();
            if (executorService instanceof ScheduledExecutorService) {
                return (ScheduledExecutorService)executorService;
            }
            throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " is not an ScheduledExecutorService instance");
        }
        if (definition.getExecutorServiceRef() != null) {
            ScheduledExecutorService answer = ProcessorDefinitionHelper.lookupScheduledExecutorServiceRef(routeContext, name, definition, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultScheduledThreadPool(definition, name);
        }
        return null;
    }
}

