/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.main.MainSupport;
import org.apache.camel.view.ModelFileGenerator;

public class Main
extends MainSupport {
    protected static Main instance;
    protected final SimpleRegistry registry = new SimpleRegistry();

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.enableHangupSupport();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    public void bind(String name, Object bean) {
        this.registry.put(name, bean);
    }

    public Object lookup(String name) {
        return this.registry.get(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.registry.lookup(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.lookupByType(type);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.postProcessContext();
        this.getCamelContexts().get(0).start();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.getCamelContexts().get(0).stop();
    }

    @Override
    protected ProducerTemplate findOrCreateCamelTemplate() {
        return this.getCamelContexts().get(0).createProducerTemplate();
    }

    @Override
    protected Map<String, CamelContext> getCamelContextMap() {
        HashMap<String, CamelContext> answer = new HashMap<String, CamelContext>();
        CamelContext camelContext = this.createContext();
        if (this.registry.size() > 0 && DefaultCamelContext.class.isAssignableFrom(camelContext.getClass())) {
            ((DefaultCamelContext)camelContext).setRegistry(this.registry);
        }
        answer.put("camel-1", camelContext);
        return answer;
    }

    protected CamelContext createContext() {
        return new DefaultCamelContext();
    }

    @Override
    protected ModelFileGenerator createModelFileGenerator() throws JAXBException {
        return null;
    }
}

