/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.interceptor.AsyncExecutionInterceptor;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAnnotationAdvisor
extends AbstractPointcutAdvisor {
    private Advice advice;
    private Pointcut pointcut;

    public AsyncAnnotationAdvisor() {
        this(new SimpleAsyncTaskExecutor());
    }

    public AsyncAnnotationAdvisor(Executor executor) {
        LinkedHashSet<Class<? extends Annotation>> asyncAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>(2);
        asyncAnnotationTypes.add(Async.class);
        ClassLoader cl = AsyncAnnotationAdvisor.class.getClassLoader();
        try {
            asyncAnnotationTypes.add(cl.loadClass("javax.ejb.Asynchronous"));
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.advice = this.buildAdvice(executor);
        this.pointcut = this.buildPointcut(asyncAnnotationTypes);
    }

    public void setTaskExecutor(Executor executor) {
        this.advice = this.buildAdvice(executor);
    }

    public void setAsyncAnnotationType(Class<? extends Annotation> asyncAnnotationType) {
        Assert.notNull(asyncAnnotationType, "'asyncAnnotationType' must not be null");
        HashSet<Class<? extends Annotation>> asyncAnnotationTypes = new HashSet<Class<? extends Annotation>>();
        asyncAnnotationTypes.add(asyncAnnotationType);
        this.pointcut = this.buildPointcut(asyncAnnotationTypes);
    }

    @Override
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    protected Advice buildAdvice(Executor executor) {
        if (executor instanceof AsyncTaskExecutor) {
            return new AsyncExecutionInterceptor((AsyncTaskExecutor)executor);
        }
        return new AsyncExecutionInterceptor(executor);
    }

    protected Pointcut buildPointcut(Set<Class<? extends Annotation>> asyncAnnotationTypes) {
        ComposablePointcut result = null;
        for (Class<? extends Annotation> asyncAnnotationType : asyncAnnotationTypes) {
            AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(asyncAnnotationType, true);
            AnnotationMatchingPointcut mpc = new AnnotationMatchingPointcut(null, asyncAnnotationType);
            if (result == null) {
                result = new ComposablePointcut(cpc).union(mpc);
                continue;
            }
            result.union(cpc).union(mpc);
        }
        return result;
    }
}

