/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.impl.MDCUnitOfWork;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.RouteContextProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.AsyncProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitOfWorkProcessor
extends DelegateAsyncProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(UnitOfWorkProcessor.class);
    private final RouteContext routeContext;
    private final String routeId;

    public UnitOfWorkProcessor(Processor processor) {
        this(null, processor);
    }

    public UnitOfWorkProcessor(AsyncProcessor processor) {
        this(null, processor);
    }

    public UnitOfWorkProcessor(RouteContext routeContext, Processor processor) {
        super(processor);
        this.routeContext = routeContext;
        this.routeId = routeContext != null ? routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory()) : null;
    }

    public UnitOfWorkProcessor(RouteContext routeContext, AsyncProcessor processor) {
        super(processor);
        this.routeContext = routeContext;
        this.routeId = routeContext != null ? routeContext.getRoute().idOrCreate(routeContext.getCamelContext().getNodeIdFactory()) : null;
    }

    @Override
    public String toString() {
        return "UnitOfWork(" + this.processor + ")";
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.routeContext != null) {
            this.processor = new RouteContextProcessor(this.routeContext, this.processor);
        }
        super.doStart();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.routeId != null && exchange.getFromRouteId() == null) {
            exchange.setFromRouteId(this.routeId);
        }
        if (exchange.getUnitOfWork() == null) {
            UnitOfWork uow = this.createUnitOfWork(exchange);
            exchange.setUnitOfWork(uow);
            try {
                uow.start();
            }
            catch (Exception e) {
                callback.done(true);
                exchange.setException(e);
                return true;
            }
            Object synchronous = exchange.removeProperty("CamelUnitOfWorkProcessSync");
            if (synchronous != null) {
                return this.processSync(exchange, callback, uow);
            }
            return this.processAsync(exchange, callback, uow);
        }
        return this.processor.process(exchange, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processSync(Exchange exchange, AsyncCallback callback, UnitOfWork uow) {
        LOG.trace("Exchange marked UnitOfWork to be processed synchronously: {}", exchange);
        try {
            AsyncProcessorHelper.process(this.processor, exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        try {
            callback.done(true);
        }
        finally {
            this.doneUow(uow, exchange);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processAsync(final Exchange exchange, final AsyncCallback callback, final UnitOfWork uow) {
        LOG.trace("Processing exchange asynchronously: {}", exchange);
        try {
            return this.processor.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(boolean doneSync) {
                    try {
                        callback.done(doneSync);
                    }
                    finally {
                        UnitOfWorkProcessor.this.doneUow(uow, exchange);
                    }
                }
            });
        }
        catch (Throwable e) {
            LOG.warn("Caught unhandled exception while processing ExchangeId: " + exchange.getExchangeId(), e);
            exchange.setException(e);
            try {
                callback.done(true);
            }
            finally {
                this.doneUow(uow, exchange);
            }
            return true;
        }
    }

    protected UnitOfWork createUnitOfWork(Exchange exchange) {
        DefaultUnitOfWork answer = exchange.getContext().isUseMDCLogging() != false ? new MDCUnitOfWork(exchange) : new DefaultUnitOfWork(exchange);
        return answer;
    }

    private void doneUow(UnitOfWork uow, Exchange exchange) {
        try {
            if (uow != null) {
                uow.done(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        try {
            if (uow != null) {
                uow.stop();
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during stopping UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        exchange.setUnitOfWork(null);
    }
}

