/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassMethod;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyCreator;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.Conventions;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassBeanDefinitionReader {
    private static final String CONFIGURATION_CLASS_FULL = "full";
    private static final String CONFIGURATION_CLASS_LITE = "lite";
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, "configurationClass");
    private static final Log logger = LogFactory.getLog(ConfigurationClassBeanDefinitionReader.class);
    private final BeanDefinitionRegistry registry;
    private final SourceExtractor sourceExtractor;
    private final ProblemReporter problemReporter;
    private final MetadataReaderFactory metadataReaderFactory;

    public ConfigurationClassBeanDefinitionReader(BeanDefinitionRegistry registry, SourceExtractor sourceExtractor, ProblemReporter problemReporter, MetadataReaderFactory metadataReaderFactory) {
        this.registry = registry;
        this.sourceExtractor = sourceExtractor;
        this.problemReporter = problemReporter;
        this.metadataReaderFactory = metadataReaderFactory;
    }

    public void loadBeanDefinitions(Set<ConfigurationClass> configurationModel) {
        for (ConfigurationClass configClass : configurationModel) {
            this.loadBeanDefinitionsForConfigurationClass(configClass);
        }
    }

    private void loadBeanDefinitionsForConfigurationClass(ConfigurationClass configClass) {
        this.doLoadBeanDefinitionForConfigurationClassIfNecessary(configClass);
        for (ConfigurationClassMethod method : configClass.getMethods()) {
            this.loadBeanDefinitionsForModelMethod(method);
        }
        this.loadBeanDefinitionsFromImportedResources(configClass.getImportedResources());
    }

    private void doLoadBeanDefinitionForConfigurationClassIfNecessary(ConfigurationClass configClass) {
        if (configClass.getBeanName() != null) {
            return;
        }
        GenericBeanDefinition configBeanDef = new GenericBeanDefinition();
        String className = configClass.getMetadata().getClassName();
        configBeanDef.setBeanClassName(className);
        if (ConfigurationClassBeanDefinitionReader.checkConfigurationClassCandidate(configBeanDef, this.metadataReaderFactory)) {
            String configBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName(configBeanDef, this.registry);
            configClass.setBeanName(configBeanName);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Registered bean definition for imported @Configuration class %s", configBeanName));
            }
        } else {
            try {
                MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
                AnnotationMetadata metadata = reader.getAnnotationMetadata();
                this.problemReporter.error(new InvalidConfigurationImportProblem(className, reader.getResource(), metadata));
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not create MetadataReader for class " + className);
            }
        }
    }

    private void loadBeanDefinitionsForModelMethod(ConfigurationClassMethod method) {
        String destroyMethodName;
        String initMethodName;
        Autowire autowire;
        String[] dependsOn;
        BeanDefinition existingBeanDef;
        ConfigurationClass configClass = method.getConfigurationClass();
        MethodMetadata metadata = method.getMetadata();
        ConfigurationClassBeanDefinition beanDef = new ConfigurationClassBeanDefinition(configClass);
        beanDef.setResource(configClass.getResource());
        beanDef.setSource(this.sourceExtractor.extractSource(metadata, configClass.getResource()));
        beanDef.setFactoryBeanName(configClass.getBeanName());
        beanDef.setUniqueFactoryMethodName(metadata.getMethodName());
        beanDef.setAutowireMode(3);
        beanDef.setAttribute(RequiredAnnotationBeanPostProcessor.SKIP_REQUIRED_CHECK_ATTRIBUTE, Boolean.TRUE);
        Map<String, Object> beanAttributes = metadata.getAnnotationAttributes(Bean.class.getName());
        ArrayList names = new ArrayList(Arrays.asList((String[])beanAttributes.get("name")));
        String beanName = names.size() > 0 ? (String)names.remove(0) : method.getMetadata().getMethodName();
        for (String alias : names) {
            this.registry.registerAlias(beanName, alias);
        }
        if (this.registry.containsBeanDefinition(beanName) && !((existingBeanDef = this.registry.getBeanDefinition(beanName)) instanceof ConfigurationClassBeanDefinition)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Skipping loading bean definition for %s: a definition for bean '%s' already exists. This is likely due to an override in XML.", method, beanName));
            }
            return;
        }
        if (metadata.isAnnotated(Primary.class.getName())) {
            beanDef.setPrimary(true);
        }
        if (metadata.isAnnotated(Lazy.class.getName())) {
            beanDef.setLazyInit((Boolean)metadata.getAnnotationAttributes(Lazy.class.getName()).get("value"));
        } else if (configClass.getMetadata().isAnnotated(Lazy.class.getName())) {
            beanDef.setLazyInit((Boolean)configClass.getMetadata().getAnnotationAttributes(Lazy.class.getName()).get("value"));
        }
        if (metadata.isAnnotated(DependsOn.class.getName()) && (dependsOn = (String[])metadata.getAnnotationAttributes(DependsOn.class.getName()).get("value")).length > 0) {
            beanDef.setDependsOn(dependsOn);
        }
        if ((autowire = (Autowire)((Object)beanAttributes.get("autowire"))).isAutowire()) {
            beanDef.setAutowireMode(autowire.value());
        }
        if (StringUtils.hasText(initMethodName = (String)beanAttributes.get("initMethod"))) {
            beanDef.setInitMethodName(initMethodName);
        }
        if (StringUtils.hasText(destroyMethodName = (String)beanAttributes.get("destroyMethod"))) {
            beanDef.setDestroyMethodName(destroyMethodName);
        }
        ScopedProxyMode proxyMode = ScopedProxyMode.NO;
        Map<String, Object> scopeAttributes = metadata.getAnnotationAttributes(Scope.class.getName());
        if (scopeAttributes != null) {
            beanDef.setScope((String)scopeAttributes.get("value"));
            proxyMode = (ScopedProxyMode)((Object)scopeAttributes.get("proxyMode"));
            if (proxyMode == ScopedProxyMode.DEFAULT) {
                proxyMode = ScopedProxyMode.NO;
            }
        }
        BeanDefinition beanDefToRegister = beanDef;
        if (proxyMode != ScopedProxyMode.NO) {
            BeanDefinitionHolder proxyDef = ScopedProxyCreator.createScopedProxy(new BeanDefinitionHolder(beanDef, beanName), this.registry, proxyMode == ScopedProxyMode.TARGET_CLASS);
            beanDefToRegister = proxyDef.getBeanDefinition();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Registering bean definition for @Bean method %s.%s()", configClass.getMetadata().getClassName(), beanName));
        }
        this.registry.registerBeanDefinition(beanName, beanDefToRegister);
    }

    private void loadBeanDefinitionsFromImportedResources(Map<String, Class<?>> importedResources) {
        HashMap readerInstanceCache = new HashMap();
        for (Map.Entry<String, Class<?>> entry : importedResources.entrySet()) {
            String resource = entry.getKey();
            Class<?> readerClass = entry.getValue();
            if (!readerInstanceCache.containsKey(readerClass)) {
                try {
                    BeanDefinitionReader readerInstance = (BeanDefinitionReader)readerClass.getConstructor(BeanDefinitionRegistry.class).newInstance(this.registry);
                    readerInstanceCache.put(readerClass, readerInstance);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Could not instantiate BeanDefinitionReader class [" + readerClass.getName() + "]");
                }
            }
            BeanDefinitionReader reader = (BeanDefinitionReader)readerInstanceCache.get(readerClass);
            reader.loadBeanDefinitions(resource);
        }
    }

    public static boolean checkConfigurationClassCandidate(BeanDefinition beanDef, MetadataReaderFactory metadataReaderFactory) {
        AnnotationMetadata metadata = null;
        if (beanDef instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)beanDef).hasBeanClass()) {
            metadata = new StandardAnnotationMetadata(((AbstractBeanDefinition)beanDef).getBeanClass());
        } else {
            String className = beanDef.getBeanClassName();
            if (className != null) {
                try {
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(className);
                    metadata = metadataReader.getAnnotationMetadata();
                }
                catch (IOException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Could not find class file for introspecting factory methods: " + className, ex);
                    }
                    return false;
                }
            }
        }
        if (metadata != null) {
            if (metadata.isAnnotated(Configuration.class.getName())) {
                beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, CONFIGURATION_CLASS_FULL);
                return true;
            }
            if (metadata.isAnnotated(Component.class.getName()) || metadata.hasAnnotatedMethods(Bean.class.getName())) {
                beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, CONFIGURATION_CLASS_LITE);
                return true;
            }
        }
        return false;
    }

    public static boolean isFullConfigurationClass(BeanDefinition beanDef) {
        return CONFIGURATION_CLASS_FULL.equals(beanDef.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE));
    }

    private static class ConfigurationClassBeanDefinition
    extends RootBeanDefinition
    implements AnnotatedBeanDefinition {
        private AnnotationMetadata annotationMetadata;

        public ConfigurationClassBeanDefinition(ConfigurationClass configClass) {
            this.annotationMetadata = configClass.getMetadata();
        }

        private ConfigurationClassBeanDefinition(ConfigurationClassBeanDefinition original) {
            super(original);
            this.annotationMetadata = original.annotationMetadata;
        }

        public AnnotationMetadata getMetadata() {
            return this.annotationMetadata;
        }

        public boolean isFactoryMethod(Method candidate) {
            return super.isFactoryMethod(candidate) && AnnotationUtils.findAnnotation(candidate, Bean.class) != null;
        }

        public ConfigurationClassBeanDefinition cloneBeanDefinition() {
            return new ConfigurationClassBeanDefinition(this);
        }
    }

    private static class InvalidConfigurationImportProblem
    extends Problem {
        public InvalidConfigurationImportProblem(String className, Resource resource, AnnotationMetadata metadata) {
            super(String.format("%s was imported as a Configuration class but is not annotated with @Configuration nor does it declare any @Bean methods. Update the class to meet either of these requirements or do not attempt to import it.", className), new Location(resource, metadata));
        }
    }
}

