/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.fusesource.fabric.stream.log.SnappyDecompressor;

public class LogStreamConsumer {
    String broker;
    String source;
    String target;
    boolean uncompress = false;

    public static void main(String[] args) throws Exception {
        LogStreamConsumer producer = new LogStreamConsumer();
        LinkedList<String> argl = new LinkedList<String>(Arrays.asList(args));
        while (!argl.isEmpty()) {
            try {
                String arg = argl.removeFirst();
                if ("--help".equals(arg)) {
                    LogStreamConsumer.displayHelpAndExit(0);
                    continue;
                }
                if ("--broker".equals(arg)) {
                    producer.broker = LogStreamConsumer.shift(argl);
                    continue;
                }
                if ("--source".equals(arg)) {
                    producer.source = LogStreamConsumer.shift(argl);
                    continue;
                }
                if ("--target".equals(arg)) {
                    producer.target = LogStreamConsumer.shift(argl);
                    continue;
                }
                if ("--uncompress".equals(arg)) {
                    producer.uncompress = Boolean.parseBoolean(LogStreamConsumer.shift(argl));
                    continue;
                }
                System.err.println("Invalid usage: unknown option: " + arg);
                LogStreamConsumer.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid usage: argument not a number");
                LogStreamConsumer.displayHelpAndExit(1);
            }
        }
        if (producer.broker == null) {
            System.err.println("Invalid usage: --broker option not specified.");
            LogStreamConsumer.displayHelpAndExit(1);
        }
        if (producer.source == null) {
            System.err.println("Invalid usage: --destination option not specified.");
            LogStreamConsumer.displayHelpAndExit(1);
        }
        producer.execute();
        System.exit(0);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            System.err.println("Invalid usage: Missing argument");
            LogStreamConsumer.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    private static void displayHelpAndExit(int exitCode) {
        System.exit(exitCode);
    }

    private void execute() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.disableJMX();
        context.addComponent("activemq", ActiveMQComponent.activeMQComponent(this.broker));
        context.addRoutes(new RouteBuilder(){

            @Override
            public void configure() throws Exception {
                RouteDefinition route = this.from("activemq:" + LogStreamConsumer.this.source);
                if (LogStreamConsumer.this.uncompress) {
                    route = (RouteDefinition)route.process(new SnappyDecompressor());
                }
                route.to(LogStreamConsumer.this.target);
            }
        });
        context.start();
        LogStreamConsumer logStreamConsumer = this;
        synchronized (logStreamConsumer) {
            while (true) {
                this.wait();
            }
        }
    }
}

