/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputBatcher
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(InputBatcherConsumer.class);
    public int batchSize = 262144;
    public long batchTimeout = 1000L;
    public InputStream is = System.in;
    static final Object EOF = new Object();

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        return new InputBatcherEndpoint(uri, this);
    }

    private static int lastnlposition(byte[] data, int len) {
        int at = -1;
        for (int i = len - 1; i >= 0; --i) {
            if (data[i] != 10) continue;
            at = i;
            break;
        }
        return at;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public InputStream getIs() {
        return this.is;
    }

    public void setIs(InputStream is) {
        this.is = is;
    }

    class InputBatcherConsumer
    extends DefaultConsumer {
        final ArrayBlockingQueue<Object> queue;
        final ExecutorService inputReader;
        final ExecutorService batchReader;
        private AsyncProcessor processor;

        InputBatcherConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
            this.queue = new ArrayBlockingQueue(1024);
            this.inputReader = Executors.newSingleThreadExecutor();
            this.batchReader = Executors.newSingleThreadExecutor();
        }

        @Override
        protected void doStart() throws Exception {
            super.doStart();
            this.inputReader.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        byte[] batch = new byte[4096];
                        int pos = 0;
                        while (InputBatcherConsumer.this.isRunAllowed()) {
                            if (InputBatcherConsumer.this.isSuspending() || InputBatcherConsumer.this.isSuspended()) {
                                LOG.trace("Consumer is suspended so skip polling");
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {
                                    LOG.debug("Sleep interrupted, are we stopping? {}", InputBatcherConsumer.this.isStopping() || InputBatcherConsumer.this.isStopped());
                                }
                                continue;
                            }
                            int count = InputBatcher.this.is.read(batch, pos, batch.length - pos);
                            if (count < 0) {
                                if (pos > 0) {
                                    byte[] data = new byte[pos];
                                    System.arraycopy(batch, 0, data, 0, pos);
                                    InputBatcherConsumer.this.queue.put(data);
                                }
                                InputBatcherConsumer.this.queue.put(EOF);
                                return;
                            }
                            int at = InputBatcher.lastnlposition(batch, pos += count);
                            if (at >= 0) {
                                int len = at + 1;
                                byte[] data = new byte[len];
                                System.arraycopy(batch, 0, data, 0, len);
                                int remaining = pos - len;
                                System.arraycopy(batch, len, batch, 0, remaining);
                                pos = remaining;
                                InputBatcherConsumer.this.queue.put(data);
                                continue;
                            }
                            if (pos != batch.length) continue;
                            InputBatcherConsumer.this.queue.put(batch);
                            batch = new byte[4096];
                            pos = 0;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.batchReader.execute(new Runnable(){

                @Override
                public void run() {
                    boolean atEOF = false;
                    while (InputBatcherConsumer.this.isRunAllowed() && !atEOF) {
                        if (InputBatcherConsumer.this.isSuspending() || InputBatcherConsumer.this.isSuspended()) {
                            LOG.trace("Consumer is suspended so skip polling");
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                LOG.debug("Sleep interrupted, are we stopping? {}", InputBatcherConsumer.this.isStopping() || InputBatcherConsumer.this.isStopped());
                            }
                            continue;
                        }
                        ByteArrayOutputStream batch = new ByteArrayOutputStream((int)((double)InputBatcher.this.batchSize * 1.5));
                        try {
                            Object obj = InputBatcherConsumer.this.queue.poll(1000L, TimeUnit.MILLISECONDS);
                            if (obj == null) continue;
                            if (obj == EOF) {
                                atEOF = true;
                                continue;
                            }
                            long start = System.currentTimeMillis();
                            long timeout = start + InputBatcher.this.batchTimeout;
                            try {
                                batch.write((byte[])obj);
                                while (batch.size() < InputBatcher.this.batchSize && !atEOF) {
                                    obj = InputBatcherConsumer.this.queue.poll();
                                    if (obj != null) {
                                        if (obj == EOF) {
                                            atEOF = true;
                                            continue;
                                        }
                                        batch.write((byte[])obj);
                                        continue;
                                    }
                                    long remaining = timeout - System.currentTimeMillis();
                                    if (remaining <= 0L || (obj = InputBatcherConsumer.this.queue.poll(remaining, TimeUnit.MILLISECONDS)) == null) break;
                                    if (obj == EOF) {
                                        atEOF = true;
                                        continue;
                                    }
                                    batch.write((byte[])obj);
                                }
                                if (batch.size() <= 0) continue;
                                byte[] body = batch.toByteArray();
                                batch.reset();
                                Exchange exchange = InputBatcherConsumer.this.getEndpoint().createExchange();
                                DefaultMessage msg = new DefaultMessage();
                                msg.setBody(body);
                                exchange.setIn(msg);
                                try {
                                    InputBatcherConsumer.this.getProcessor().process(exchange);
                                    if (exchange.getException() == null) continue;
                                    InputBatcherConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                                }
                                catch (Exception e) {
                                    InputBatcherConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                                }
                            }
                            catch (Exception e) {
                                LOG.info("Error processing exchange.", e);
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.debug("Sleep interrupted, are we stopping? {}", InputBatcherConsumer.this.isStopping() || InputBatcherConsumer.this.isStopped());
                        }
                    }
                    if (atEOF && InputBatcherConsumer.this.isRunAllowed()) {
                        Exchange exchange = InputBatcherConsumer.this.getEndpoint().createExchange();
                        DefaultMessage msg = new DefaultMessage();
                        msg.setHeader("EOF", "true");
                        msg.setBody(new byte[0]);
                        exchange.setIn(msg);
                        try {
                            InputBatcherConsumer.this.getProcessor().process(exchange);
                            if (exchange.getException() != null) {
                                InputBatcherConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                            }
                        }
                        catch (Exception e) {
                            InputBatcherConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                        }
                        System.exit(0);
                    }
                }
            });
        }

        @Override
        protected void doStop() throws Exception {
            this.inputReader.shutdown();
            this.batchReader.shutdown();
            super.doStop();
        }
    }

    class InputBatcherEndpoint
    extends DefaultEndpoint {
        InputBatcherEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public Producer createProducer() throws Exception {
            throw new UnsupportedOperationException("Producer not supported!");
        }

        @Override
        public Consumer createConsumer(Processor processor) throws Exception {
            return new InputBatcherConsumer(this, processor);
        }
    }
}

