/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.journal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.DataFileAccessor;
import org.apache.kahadb.journal.Journal;

public class DataFileAccessorPool {
    private final Journal journal;
    private final Map<Integer, Pool> pools = new HashMap<Integer, Pool>();
    private boolean closed;
    private int maxOpenReadersPerFile = 5;

    public DataFileAccessorPool(Journal dataManager) {
        this.journal = dataManager;
    }

    synchronized void clearUsedMark() {
        for (Pool pool : this.pools.values()) {
            pool.clearUsedMark();
        }
    }

    synchronized void disposeUnused() {
        Iterator<Pool> iter = this.pools.values().iterator();
        while (iter.hasNext()) {
            Pool pool = iter.next();
            if (pool.isUsed()) continue;
            pool.dispose();
            iter.remove();
        }
    }

    synchronized void disposeDataFileAccessors(DataFile dataFile) {
        if (this.closed) {
            throw new IllegalStateException("Closed.");
        }
        Pool pool = this.pools.get(dataFile.getDataFileId());
        if (pool != null) {
            if (pool.getOpenCounter() == 0) {
                pool.dispose();
                this.pools.remove(dataFile.getDataFileId());
            } else {
                throw new IllegalStateException("The data file is still in use: " + dataFile + ", use count: " + pool.getOpenCounter());
            }
        }
    }

    synchronized DataFileAccessor openDataFileAccessor(DataFile dataFile) throws IOException {
        if (this.closed) {
            throw new IOException("Closed.");
        }
        Pool pool = this.pools.get(dataFile.getDataFileId());
        if (pool == null) {
            pool = new Pool(dataFile);
            this.pools.put(dataFile.getDataFileId(), pool);
        }
        return pool.openDataFileReader();
    }

    synchronized void closeDataFileAccessor(DataFileAccessor reader) {
        Pool pool = this.pools.get(reader.getDataFile().getDataFileId());
        if (pool == null || this.closed) {
            reader.dispose();
        } else {
            pool.closeDataFileReader(reader);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Pool pool : this.pools.values()) {
            pool.dispose();
        }
        this.pools.clear();
    }

    class Pool {
        private final DataFile file;
        private final List<DataFileAccessor> pool = new ArrayList<DataFileAccessor>();
        private boolean used;
        private int openCounter;
        private boolean disposed;

        public Pool(DataFile file) {
            this.file = file;
        }

        public DataFileAccessor openDataFileReader() throws IOException {
            DataFileAccessor rc = null;
            rc = this.pool.isEmpty() ? new DataFileAccessor(DataFileAccessorPool.this.journal, this.file) : this.pool.remove(this.pool.size() - 1);
            this.used = true;
            ++this.openCounter;
            return rc;
        }

        public synchronized void closeDataFileReader(DataFileAccessor reader) {
            --this.openCounter;
            if (this.pool.size() >= DataFileAccessorPool.this.maxOpenReadersPerFile || this.disposed) {
                reader.dispose();
            } else {
                this.pool.add(reader);
            }
        }

        public synchronized void clearUsedMark() {
            this.used = false;
        }

        public synchronized boolean isUsed() {
            return this.used;
        }

        public synchronized void dispose() {
            for (DataFileAccessor reader : this.pool) {
                reader.dispose();
            }
            this.pool.clear();
            this.disposed = true;
        }

        public synchronized int getOpenCounter() {
            return this.openCounter;
        }
    }
}

