/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.AlreadyClosedException;
import org.apache.activemq.EnhancedConnection;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.pool.ConnectionPool;
import org.apache.activemq.pool.SessionKey;

public class PooledConnection
implements TopicConnection,
QueueConnection,
EnhancedConnection {
    private ConnectionPool pool;
    private boolean stopped;

    public PooledConnection(ConnectionPool pool) {
        this.pool = pool;
        this.pool.incrementReferenceCount();
    }

    public PooledConnection newInstance() {
        return new PooledConnection(this.pool);
    }

    @Override
    public void close() throws JMSException {
        if (this.pool != null) {
            this.pool.decrementReferenceCount();
            this.pool = null;
        }
    }

    @Override
    public void start() throws JMSException {
        this.assertNotClosed();
        this.pool.start();
    }

    @Override
    public void stop() throws JMSException {
        this.stopped = true;
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(destination, selector, serverSessionPool, maxMessages);
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(topic, s, serverSessionPool, maxMessages);
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String selector, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getConnection().createDurableConnectionConsumer(topic, selector, s1, serverSessionPool, i);
    }

    @Override
    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getConnection().setExceptionListener(exceptionListener);
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        if (this.getConnection().getClientID() == null || !this.getClientID().equals(clientID)) {
            this.getConnection().setClientID(clientID);
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(queue, selector, serverSessionPool, maxMessages);
    }

    @Override
    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    @Override
    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        return this.pool.createSession(transacted, ackMode);
    }

    @Override
    public DestinationSource getDestinationSource() throws JMSException {
        return this.getConnection().getDestinationSource();
    }

    public ActiveMQConnection getConnection() throws JMSException {
        this.assertNotClosed();
        return this.pool.getConnection();
    }

    protected void assertNotClosed() throws AlreadyClosedException {
        if (this.stopped || this.pool == null) {
            throw new AlreadyClosedException();
        }
    }

    protected ActiveMQSession createSession(SessionKey key) throws JMSException {
        return (ActiveMQSession)this.getConnection().createSession(key.isTransacted(), key.getAckMode());
    }

    public String toString() {
        return "PooledConnection { " + this.pool + " }";
    }
}

