/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;

final class JodaTimeConverters {
    JodaTimeConverters() {
    }

    public static void registerConverters(ConverterRegistry registry) {
        registry.addConverter(new DateTimeToLocalDateConverter());
        registry.addConverter(new DateTimeToLocalTimeConverter());
        registry.addConverter(new DateTimeToLocalDateTimeConverter());
        registry.addConverter(new DateTimeToDateMidnightConverter());
        registry.addConverter(new DateTimeToDateConverter());
        registry.addConverter(new DateTimeToCalendarConverter());
        registry.addConverter(new DateTimeToLongConverter());
        registry.addConverter(new DateToLongConverter());
        registry.addConverter(new CalendarToReadableInstantConverter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarToReadableInstantConverter
    implements Converter<Calendar, ReadableInstant> {
        private CalendarToReadableInstantConverter() {
        }

        @Override
        public ReadableInstant convert(Calendar source) {
            return new DateTime((Object)source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToCalendarConverter
    implements Converter<DateTime, Calendar> {
        private DateTimeToCalendarConverter() {
        }

        @Override
        public Calendar convert(DateTime source) {
            return source.toGregorianCalendar();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToDateConverter
    implements Converter<DateTime, Date> {
        private DateTimeToDateConverter() {
        }

        @Override
        public Date convert(DateTime source) {
            return source.toDate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToDateMidnightConverter
    implements Converter<DateTime, DateMidnight> {
        private DateTimeToDateMidnightConverter() {
        }

        @Override
        public DateMidnight convert(DateTime source) {
            return source.toDateMidnight();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLocalDateConverter
    implements Converter<DateTime, LocalDate> {
        private DateTimeToLocalDateConverter() {
        }

        @Override
        public LocalDate convert(DateTime source) {
            return source.toLocalDate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLocalDateTimeConverter
    implements Converter<DateTime, LocalDateTime> {
        private DateTimeToLocalDateTimeConverter() {
        }

        @Override
        public LocalDateTime convert(DateTime source) {
            return source.toLocalDateTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLocalTimeConverter
    implements Converter<DateTime, LocalTime> {
        private DateTimeToLocalTimeConverter() {
        }

        @Override
        public LocalTime convert(DateTime source) {
            return source.toLocalTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateTimeToLongConverter
    implements Converter<DateTime, Long> {
        private DateTimeToLongConverter() {
        }

        @Override
        public Long convert(DateTime source) {
            return source.getMillis();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateToLongConverter
    implements Converter<Date, Long> {
        private DateToLongConverter() {
        }

        @Override
        public Long convert(Date source) {
            return source.getTime();
        }
    }
}

