/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.stream.log;

import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.fusesource.fabric.stream.log.InputBatcher;
import org.fusesource.fabric.stream.log.SnappyCompressor;

public class LogStreamProducer {
    private String broker;
    private String destination;
    private int batchSize = 65536;
    private long batchTimeout = 5000L;
    private boolean compress = true;
    private InputStream is = System.in;

    public static void main(String[] args) throws Exception {
        LogStreamProducer producer = new LogStreamProducer();
        LinkedList<String> argl = new LinkedList<String>(Arrays.asList(args));
        while (!argl.isEmpty()) {
            try {
                String arg = argl.removeFirst();
                if ("--help".equals(arg)) {
                    LogStreamProducer.displayHelpAndExit(0);
                    continue;
                }
                if ("--broker".equals(arg)) {
                    producer.broker = LogStreamProducer.shift(argl);
                    continue;
                }
                if ("--destination".equals(arg)) {
                    producer.destination = LogStreamProducer.shift(argl);
                    continue;
                }
                if ("--batch-size".equals(arg)) {
                    producer.batchSize = Integer.parseInt(LogStreamProducer.shift(argl));
                    continue;
                }
                if ("--batch-timeout".equals(arg)) {
                    producer.batchTimeout = Long.parseLong(LogStreamProducer.shift(argl));
                    continue;
                }
                if ("--compress".equals(arg)) {
                    producer.compress = Boolean.parseBoolean(LogStreamProducer.shift(argl));
                    continue;
                }
                System.err.println("Invalid usage: unknown option: " + arg);
                LogStreamProducer.displayHelpAndExit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid usage: argument not a number");
                LogStreamProducer.displayHelpAndExit(1);
            }
        }
        if (producer.broker == null) {
            System.err.println("Invalid usage: --broker option not specified.");
            LogStreamProducer.displayHelpAndExit(1);
        }
        if (producer.destination == null) {
            System.err.println("Invalid usage: --destination option not specified.");
            LogStreamProducer.displayHelpAndExit(1);
        }
        producer.execute();
        System.exit(0);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            System.err.println("Invalid usage: Missing argument");
            LogStreamProducer.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    private static void displayHelpAndExit(int exitCode) {
        System.exit(exitCode);
    }

    private void execute() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        this.configure(context);
        context.start();
        LogStreamProducer logStreamProducer = this;
        synchronized (logStreamProducer) {
            while (true) {
                this.wait();
            }
        }
    }

    public void configure(CamelContext context) throws Exception {
        context.disableJMX();
        context.addComponent("activemq", ActiveMQComponent.activeMQComponent(this.broker));
        final InputBatcher batcher = new InputBatcher();
        batcher.setBatchSize(this.batchSize);
        batcher.setBatchTimeout(this.batchTimeout);
        batcher.setIs(this.is);
        context.addComponent("batcher", batcher);
        context.addRoutes(new RouteBuilder(){

            @Override
            public void configure() throws Exception {
                Endpoint source = batcher.createEndpoint("stdin");
                RouteDefinition route = this.from(source);
                if (LogStreamProducer.this.compress) {
                    route = (RouteDefinition)route.process(new SnappyCompressor());
                }
                route.to("activemq:" + LogStreamProducer.this.destination);
            }
        });
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(long batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public String getBroker() {
        return this.broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public InputStream getIs() {
        return this.is;
    }

    public void setIs(InputStream is) {
        this.is = is;
    }
}

