/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.ObjectHelper;

public class StaticMethodTypeConverter
extends TypeConverterSupport {
    private final Method method;
    private final boolean useExchange;

    public StaticMethodTypeConverter(Method method) {
        this.method = method;
        this.useExchange = method.getParameterTypes().length == 2;
    }

    public String toString() {
        return "StaticMethodTypeConverter: " + this.method;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)(this.useExchange ? ObjectHelper.invokeMethod(this.method, null, value, exchange) : ObjectHelper.invokeMethod(this.method, null, value));
    }
}

