/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Channel;
import org.apache.camel.Consumer;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.ChildServiceSupport;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteService
extends ChildServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RouteService.class);
    private final DefaultCamelContext camelContext;
    private final RouteDefinition routeDefinition;
    private final List<RouteContext> routeContexts;
    private final List<Route> routes;
    private final String id;
    private boolean removingRoutes;
    private final Map<Route, Consumer> inputs = new HashMap<Route, Consumer>();
    private final AtomicBoolean warmUpDone = new AtomicBoolean(false);
    private final AtomicBoolean endpointDone = new AtomicBoolean(false);

    public RouteService(DefaultCamelContext camelContext, RouteDefinition routeDefinition, List<RouteContext> routeContexts, List<Route> routes) {
        this.camelContext = camelContext;
        this.routeDefinition = routeDefinition;
        this.routeContexts = routeContexts;
        this.routes = routes;
        this.id = routeDefinition.idOrCreate(camelContext.getNodeIdFactory());
    }

    public String getId() {
        return this.id;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public List<RouteContext> getRouteContexts() {
        return this.routeContexts;
    }

    public RouteDefinition getRouteDefinition() {
        return this.routeDefinition;
    }

    public Collection<Route> getRoutes() {
        return this.routes;
    }

    public Map<Route, Consumer> getInputs() {
        return this.inputs;
    }

    public boolean isRemovingRoutes() {
        return this.removingRoutes;
    }

    public void setRemovingRoutes(boolean removingRoutes) {
        this.removingRoutes = removingRoutes;
    }

    public synchronized void warmUp() throws Exception {
        if (this.endpointDone.compareAndSet(false, true)) {
            for (Route route : this.routes) {
                ServiceHelper.startService(route.getEndpoint());
            }
        }
        if (this.warmUpDone.compareAndSet(false, true)) {
            for (Route route : this.routes) {
                route.warmUp();
                LOG.debug("Starting services on route: {}", (Object)route.getId());
                List<Service> services = route.getServices();
                route.onStartingServices(services);
                LinkedHashSet<Service> list = new LinkedHashSet<Service>();
                for (Service service : services) {
                    RouteService.doGetChildServices(list, service);
                }
                ArrayList<Service> childServices = new ArrayList<Service>();
                for (Service service : list) {
                    if (service instanceof Consumer) {
                        this.inputs.put(route, (Consumer)service);
                        continue;
                    }
                    childServices.add(service);
                }
                this.startChildService(route, childServices);
            }
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesAdd(this.routes);
            }
            this.camelContext.addRouteCollection(this.routes);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.warmUp();
        for (Route route : this.routes) {
            ServiceHelper.startService(route);
            if (this.routeDefinition.getRoutePolicies() != null) {
                for (RoutePolicy routePolicy : this.routeDefinition.getRoutePolicies()) {
                    routePolicy.onStart(route);
                }
            }
            EventHelper.notifyRouteStarted(this.camelContext, route);
        }
    }

    @Override
    protected void doStop() throws Exception {
        boolean isShutdownCamelContext = this.camelContext.isStopping();
        if (isShutdownCamelContext || this.isRemovingRoutes()) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesRemove(this.routes);
            }
        }
        for (Route route : this.routes) {
            LOG.debug("Stopping services on route: {}", (Object)route.getId());
            ArrayList<Service> services = new ArrayList<Service>();
            services.addAll(route.getServices());
            this.doGetRouteScopedServices(services, route);
            LinkedHashSet<Service> list = new LinkedHashSet<Service>();
            for (Service service : services) {
                RouteService.doGetChildServices(list, service);
            }
            this.doGetRouteScopedErrorHandler(list, route);
            this.stopChildService(route, list, isShutdownCamelContext);
            if (isShutdownCamelContext) {
                ServiceHelper.stopAndShutdownServices(route);
            } else {
                ServiceHelper.stopServices(route);
            }
            if (this.routeDefinition.getRoutePolicies() != null) {
                for (RoutePolicy routePolicy : this.routeDefinition.getRoutePolicies()) {
                    routePolicy.onStop(route);
                }
            }
            EventHelper.notifyRouteStopped(this.camelContext, route);
        }
        if (this.isRemovingRoutes()) {
            this.camelContext.removeRouteCollection(this.routes);
        }
        this.warmUpDone.set(false);
    }

    @Override
    protected void doShutdown() throws Exception {
        for (Route route : this.routes) {
            LOG.debug("Shutting down services on route: {}", (Object)route.getId());
            ArrayList<Service> services = new ArrayList<Service>();
            services.addAll(route.getServices());
            this.doGetRouteScopedServices(services, route);
            LinkedHashSet<Service> list = new LinkedHashSet<Service>();
            for (Service service : services) {
                RouteService.doGetChildServices(list, service);
            }
            this.doGetRouteScopedErrorHandler(list, route);
            this.stopChildService(route, list, true);
            ServiceHelper.stopAndShutdownServices(route);
            ServiceHelper.stopAndShutdownServices(route.getEndpoint());
            if (this.routeDefinition.getRoutePolicies() == null) continue;
            for (RoutePolicy routePolicy : this.routeDefinition.getRoutePolicies()) {
                routePolicy.onRemove(route);
            }
        }
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRoutesRemove(this.routes);
        }
        for (Route route : this.routes) {
            this.camelContext.getInflightRepository().removeRoute(route.getId());
        }
        this.camelContext.removeRouteCollection(this.routes);
        this.inputs.clear();
        this.warmUpDone.set(false);
        this.endpointDone.set(false);
    }

    @Override
    protected void doSuspend() throws Exception {
        for (Route route : this.routes) {
            if (this.routeDefinition.getRoutePolicies() == null) continue;
            for (RoutePolicy routePolicy : this.routeDefinition.getRoutePolicies()) {
                routePolicy.onSuspend(route);
            }
        }
    }

    @Override
    protected void doResume() throws Exception {
        for (Route route : this.routes) {
            if (this.routeDefinition.getRoutePolicies() == null) continue;
            for (RoutePolicy routePolicy : this.routeDefinition.getRoutePolicies()) {
                routePolicy.onResume(route);
            }
        }
    }

    protected void startChildService(Route route, List<Service> services) throws Exception {
        for (Service service : services) {
            LOG.debug("Starting child service on route: {} -> {}", (Object)route.getId(), (Object)service);
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceAdd(this.camelContext, service, route);
            }
            ServiceHelper.startService(service);
            this.addChildService(service);
        }
    }

    protected void stopChildService(Route route, Set<Service> services, boolean shutdown) throws Exception {
        for (Service service : services) {
            LOG.debug("{} child service on route: {} -> {}", new Object[]{shutdown ? "Shutting down" : "Stopping", route.getId(), service});
            if (service instanceof ErrorHandler) {
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    strategy.onErrorHandlerRemove(route.getRouteContext(), (Processor)((Object)service), route.getRouteContext().getRoute().getErrorHandlerBuilder());
                }
            } else {
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    strategy.onServiceRemove(this.camelContext, service, route);
                }
            }
            if (shutdown) {
                ServiceHelper.stopAndShutdownService(service);
            } else {
                ServiceHelper.stopService(service);
            }
            this.removeChildService(service);
        }
    }

    private void doGetRouteScopedErrorHandler(Set<Service> services, Route route) {
        boolean includeErrorHandler = !this.routeDefinition.isContextScopedErrorHandler(route.getRouteContext().getCamelContext());
        ArrayList<Service> extra = new ArrayList<Service>();
        if (includeErrorHandler) {
            for (Service service : services) {
                Processor eh;
                if (!(service instanceof Channel) || (eh = ((Channel)((Object)service)).getErrorHandler()) == null || !(eh instanceof Service)) continue;
                extra.add((Service)((Object)eh));
            }
        }
        if (!extra.isEmpty()) {
            services.addAll(extra);
        }
    }

    private void doGetRouteScopedServices(List<Service> services, Route route) {
        for (ProcessorDefinition output : route.getRouteContext().getRoute().getOutputs()) {
            Processor onCompletionProcessor;
            OnCompletionDefinition onCompletionDefinition;
            if (output instanceof OnExceptionDefinition) {
                Processor errorHandler;
                OnExceptionDefinition onExceptionDefinition = (OnExceptionDefinition)output;
                if (!onExceptionDefinition.isRouteScoped() || (errorHandler = onExceptionDefinition.getErrorHandler(route.getId())) == null || !(errorHandler instanceof Service)) continue;
                services.add((Service)((Object)errorHandler));
                continue;
            }
            if (!(output instanceof OnCompletionDefinition) || !(onCompletionDefinition = (OnCompletionDefinition)output).isRouteScoped() || (onCompletionProcessor = onCompletionDefinition.getOnCompletion(route.getId())) == null || !(onCompletionProcessor instanceof Service)) continue;
            services.add((Service)((Object)onCompletionProcessor));
        }
    }

    private static void doGetChildServices(Set<Service> services, Service service) throws Exception {
        Navigate nav;
        services.add(service);
        if (service instanceof Navigate && (nav = (Navigate)((Object)service)).hasNext()) {
            List children = nav.next();
            for (Object child : children) {
                if (!(child instanceof Service)) continue;
                RouteService.doGetChildServices(services, (Service)child);
            }
        }
    }
}

