/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.camel.component.jms.MessageSentCallback;
import org.apache.camel.component.jms.reply.MessageSelectorCreator;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseMessageIdAsCorrelationIdMessageSentCallback
implements MessageSentCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSelectorCreator.class);
    private ReplyManager replyManager;
    private String correlationId;
    private long requestTimeout;

    public UseMessageIdAsCorrelationIdMessageSentCallback(ReplyManager replyManager, String correlationId, long requestTimeout) {
        this.replyManager = replyManager;
        this.correlationId = correlationId;
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void sent(Session session, Message message, Destination destination) {
        String newCorrelationID = null;
        try {
            newCorrelationID = message.getJMSMessageID();
        }
        catch (JMSException e) {
            LOG.warn("Cannot get JMSMessageID from message: " + message + ". This exception will be ignored.", e);
        }
        if (newCorrelationID != null) {
            this.replyManager.updateCorrelationId(this.correlationId, newCorrelationID, this.requestTimeout);
        }
    }
}

