/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.command.BaseCommand;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;
import org.apache.activemq.store.kahadaptor.KahaTransactionStore;
import org.apache.activemq.store.kahadaptor.TxCommand;

class KahaTransaction {
    protected List<TxCommand> list = new ArrayList<TxCommand>();

    KahaTransaction() {
    }

    void add(KahaMessageStore store, BaseCommand command) {
        TxCommand tx = new TxCommand();
        tx.setCommand(command);
        tx.setMessageStoreKey(store.getId());
        this.list.add(tx);
    }

    public void add(KahaMessageStore destination, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) {
        TxCommand tx = new TxCommand();
        tx.setCommand(ack);
        tx.setMessageStoreKey(destination.getId());
        tx.setClientId(clientId);
        tx.setSubName(subscriptionName);
        tx.setMessageId(messageId);
        this.list.add(tx);
    }

    Message[] getMessages() {
        ArrayList<BaseCommand> result = new ArrayList<BaseCommand>();
        for (int i = 0; i < this.list.size(); ++i) {
            TxCommand command = this.list.get(i);
            if (!command.isAdd()) continue;
            result.add(command.getCommand());
        }
        Message[] messages = new Message[result.size()];
        return result.toArray(messages);
    }

    MessageAck[] getAcks() {
        ArrayList<BaseCommand> result = new ArrayList<BaseCommand>();
        for (int i = 0; i < this.list.size(); ++i) {
            TxCommand command = this.list.get(i);
            if (!command.isRemove()) continue;
            result.add(command.getCommand());
        }
        MessageAck[] acks = new MessageAck[result.size()];
        return result.toArray(acks);
    }

    void prepare() {
    }

    void rollback() {
        this.list.clear();
    }

    void commit(KahaTransactionStore transactionStore) throws IOException {
        MessageStore ms;
        TxCommand command;
        int i;
        for (i = 0; i < this.list.size(); ++i) {
            command = this.list.get(i);
            ms = transactionStore.getStoreById(command.getMessageStoreKey());
            if (!command.isAdd()) continue;
            ms.addMessage(null, (Message)command.getCommand());
        }
        for (i = 0; i < this.list.size(); ++i) {
            command = this.list.get(i);
            ms = transactionStore.getStoreById(command.getMessageStoreKey());
            if (command.isRemove()) {
                ms.removeMessage(null, (MessageAck)command.getCommand());
                continue;
            }
            if (!command.isAck()) continue;
            ((TopicMessageStore)ms).acknowledge(null, command.getClientId(), command.getSubscriptionName(), command.getMessageId(), (MessageAck)command.getCommand());
        }
    }

    List<TxCommand> getList() {
        return new ArrayList<TxCommand>(this.list);
    }

    void setList(List<TxCommand> list) {
        this.list = list;
    }
}

