/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public abstract class MessageSourceSupport {
    private static final MessageFormat INVALID_MESSAGE_FORMAT = new MessageFormat("");
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean alwaysUseMessageFormat = false;
    private final Map<String, MessageFormat> cachedMessageFormats = new HashMap<String, MessageFormat>();

    public void setAlwaysUseMessageFormat(boolean alwaysUseMessageFormat) {
        this.alwaysUseMessageFormat = alwaysUseMessageFormat;
    }

    protected boolean isAlwaysUseMessageFormat() {
        return this.alwaysUseMessageFormat;
    }

    protected String renderDefaultMessage(String defaultMessage, Object[] args, Locale locale) {
        return this.formatMessage(defaultMessage, args, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatMessage(String msg, Object[] args, Locale locale) {
        MessageFormat messageFormat;
        if (msg == null || !this.alwaysUseMessageFormat && ObjectUtils.isEmpty(args)) {
            return msg;
        }
        Object object = this.cachedMessageFormats;
        synchronized (object) {
            messageFormat = this.cachedMessageFormats.get(msg);
            if (messageFormat == null) {
                try {
                    messageFormat = this.createMessageFormat(msg, locale);
                }
                catch (IllegalArgumentException ex) {
                    if (this.alwaysUseMessageFormat) {
                        throw ex;
                    }
                    messageFormat = INVALID_MESSAGE_FORMAT;
                }
                this.cachedMessageFormats.put(msg, messageFormat);
            }
        }
        if (messageFormat == INVALID_MESSAGE_FORMAT) {
            return msg;
        }
        object = messageFormat;
        synchronized (object) {
            return messageFormat.format(this.resolveArguments(args, locale));
        }
    }

    protected MessageFormat createMessageFormat(String msg, Locale locale) {
        return new MessageFormat(msg != null ? msg : "", locale);
    }

    protected Object[] resolveArguments(Object[] args, Locale locale) {
        return args;
    }
}

