/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(PackageHelper.class);

    private PackageHelper() {
    }

    public static boolean isValidVersion(String packageName, double minimumVersion) {
        block6: {
            try {
                String value;
                Package spring = Package.getPackage(packageName);
                if (spring != null && (value = spring.getImplementationVersion()) != null) {
                    int idx = value.indexOf(46);
                    if (idx >= 0) {
                        StringBuilder buffer = new StringBuilder(value.substring(0, ++idx));
                        int size = value.length();
                        for (int i = idx; i < size; ++i) {
                            char ch = value.charAt(i);
                            if (!Character.isDigit(ch)) continue;
                            buffer.append(ch);
                        }
                        value = buffer.toString();
                    }
                    if (ObjectHelper.isNotEmpty(value)) {
                        double number = Double.parseDouble(value);
                        return number >= minimumVersion;
                    }
                    LOG.debug("Failed to find out version from package: " + packageName);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("Failed to find out version from package: " + packageName, e);
            }
        }
        return true;
    }
}

