/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.MainSupport;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.handler.CamelNamespaceHandler;
import org.apache.camel.view.ModelFileGenerator;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Main
extends MainSupport {
    protected static Main instance;
    private String applicationContextUri = "META-INF/spring/*.xml";
    private String fileApplicationContextUri;
    private AbstractApplicationContext applicationContext;
    private AbstractApplicationContext parentApplicationContext;
    private String parentApplicationContextUri;

    public Main() {
        this.addOption(new MainSupport.ParameterOption("ac", "applicationContext", "Sets the classpath based spring ApplicationContext", "applicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setApplicationContextUri(parameter);
            }
        });
        this.addOption(new MainSupport.ParameterOption("fa", "fileApplicationContext", "Sets the filesystem based spring ApplicationContext", "fileApplicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setFileApplicationContextUri(parameter);
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.enableHangupSupport();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    public String getFileApplicationContextUri() {
        return this.fileApplicationContextUri;
    }

    public void setFileApplicationContextUri(String fileApplicationContextUri) {
        this.fileApplicationContextUri = fileApplicationContextUri;
    }

    public AbstractApplicationContext getParentApplicationContext() {
        if (this.parentApplicationContext == null && this.parentApplicationContextUri != null) {
            this.parentApplicationContext = new ClassPathXmlApplicationContext(this.parentApplicationContextUri);
            this.parentApplicationContext.start();
        }
        return this.parentApplicationContext;
    }

    public void setParentApplicationContext(AbstractApplicationContext parentApplicationContext) {
        this.parentApplicationContext = parentApplicationContext;
    }

    public String getParentApplicationContextUri() {
        return this.parentApplicationContextUri;
    }

    public void setParentApplicationContextUri(String parentApplicationContextUri) {
        this.parentApplicationContextUri = parentApplicationContextUri;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.applicationContext == null) {
            this.applicationContext = this.createDefaultApplicationContext();
        }
        LOG.debug("Starting Spring ApplicationContext: " + this.applicationContext.getId());
        this.applicationContext.start();
        this.postProcessContext();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.applicationContext != null) {
            LOG.debug("Stopping Spring ApplicationContext: " + this.applicationContext.getId());
            this.applicationContext.close();
        }
    }

    @Override
    protected ProducerTemplate findOrCreateCamelTemplate() {
        String[] names = this.getApplicationContext().getBeanNamesForType(ProducerTemplate.class);
        if (names != null && names.length > 0) {
            return this.getApplicationContext().getBean(names[0], ProducerTemplate.class);
        }
        if (this.getCamelContexts().isEmpty()) {
            throw new IllegalArgumentException("No CamelContexts are available so cannot create a ProducerTemplate!");
        }
        return this.getCamelContexts().get(0).createProducerTemplate();
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        if (this.getFileApplicationContextUri() != null) {
            String[] args = this.getFileApplicationContextUri().split(";");
            AbstractApplicationContext parentContext = this.getParentApplicationContext();
            if (parentContext != null) {
                return new FileSystemXmlApplicationContext(args, parentContext);
            }
            return new FileSystemXmlApplicationContext(args);
        }
        String[] args = this.getApplicationContextUri().split(";");
        AbstractApplicationContext parentContext = this.getParentApplicationContext();
        if (parentContext != null) {
            return new ClassPathXmlApplicationContext(args, parentContext);
        }
        return new ClassPathXmlApplicationContext(args);
    }

    @Override
    protected Map<String, CamelContext> getCamelContextMap() {
        Map<String, SpringCamelContext> map = this.applicationContext.getBeansOfType(SpringCamelContext.class);
        Set<Map.Entry<String, SpringCamelContext>> entries = map.entrySet();
        HashMap<String, CamelContext> answer = new HashMap<String, CamelContext>();
        for (Map.Entry<String, SpringCamelContext> entry : entries) {
            String name = entry.getKey();
            CamelContext camelContext = entry.getValue();
            answer.put(name, camelContext);
        }
        return answer;
    }

    @Override
    protected ModelFileGenerator createModelFileGenerator() throws JAXBException {
        return new ModelFileGenerator(new CamelNamespaceHandler().getJaxbContext());
    }
}

