/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public class DelegateProcessor
extends ServiceSupport
implements Processor,
Navigate<Processor> {
    protected Processor processor;

    public DelegateProcessor() {
    }

    public DelegateProcessor(Processor processor) {
        if (processor == this) {
            throw new IllegalArgumentException("Recursive DelegateProcessor!");
        }
        this.processor = processor;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.processNext(exchange);
    }

    protected void processNext(Exchange exchange) throws Exception {
        if (this.processor != null) {
            this.processor.process(exchange);
        }
    }

    public String toString() {
        return "Delegate[" + this.processor + "]";
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processor);
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }
}

