/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.SecurityContext;

public class SimpleAuthenticationBroker
extends BrokerFilter {
    private boolean anonymousAccessAllowed = false;
    private String anonymousUser;
    private String anonymousGroup;
    private final Map userPasswords;
    private final Map userGroups;
    private final CopyOnWriteArrayList<SecurityContext> securityContexts = new CopyOnWriteArrayList();

    public SimpleAuthenticationBroker(Broker next, Map userPasswords, Map userGroups) {
        super(next);
        this.userPasswords = userPasswords;
        this.userGroups = userGroups;
    }

    public void setAnonymousAccessAllowed(boolean anonymousAccessAllowed) {
        this.anonymousAccessAllowed = anonymousAccessAllowed;
    }

    public void setAnonymousUser(String anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public void setAnonymousGroup(String anonymousGroup) {
        this.anonymousGroup = anonymousGroup;
    }

    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        SecurityContext s = context.getSecurityContext();
        if (s == null) {
            if (this.anonymousAccessAllowed && info.getUserName() == null && info.getPassword() == null) {
                info.setUserName(this.anonymousUser);
                s = new SecurityContext(info.getUserName()){

                    public Set getPrincipals() {
                        HashSet<GroupPrincipal> groups = new HashSet<GroupPrincipal>();
                        groups.add(new GroupPrincipal(SimpleAuthenticationBroker.this.anonymousGroup));
                        return groups;
                    }
                };
            } else {
                String pw = (String)this.userPasswords.get(info.getUserName());
                if (pw == null || !pw.equals(info.getPassword())) {
                    throw new SecurityException("User name [" + info.getUserName() + "] or password is invalid.");
                }
                final Set groups = (Set)this.userGroups.get(info.getUserName());
                s = new SecurityContext(info.getUserName()){

                    @Override
                    public Set<?> getPrincipals() {
                        return groups;
                    }
                };
            }
            context.setSecurityContext(s);
            this.securityContexts.add(s);
        }
        try {
            super.addConnection(context, info);
        }
        catch (Exception e) {
            this.securityContexts.remove(s);
            context.setSecurityContext(null);
            throw e;
        }
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        if (this.securityContexts.remove(context.getSecurityContext())) {
            context.setSecurityContext(null);
        }
    }

    public void refresh() {
        for (SecurityContext sc : this.securityContexts) {
            sc.getAuthorizedReadDests().clear();
            sc.getAuthorizedWriteDests().clear();
        }
    }
}

