/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.MBeanNetworkListener;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeFactory;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryNetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private Map<String, String> parameters;

    public DiscoveryNetworkConnector() {
    }

    public DiscoveryNetworkConnector(URI discoveryURI) throws IOException {
        this.setUri(discoveryURI);
    }

    public void setUri(URI discoveryURI) throws IOException {
        this.setDiscoveryAgent(DiscoveryAgentFactory.createDiscoveryAgent(discoveryURI));
        try {
            this.parameters = URISupport.parseParameters(discoveryURI);
            IntrospectionSupport.setProperties(this.getDiscoveryAgent(), this.parameters);
        }
        catch (URISyntaxException e) {
            LOG.warn("failed to parse query parameters from discoveryURI: " + discoveryURI, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceAdd(DiscoveryEvent event) {
        if (this.serviceSupport.isStopped() || this.serviceSupport.isStopping()) {
            return;
        }
        String url = event.getServiceName();
        if (url != null) {
            Transport localTransport;
            Transport remoteTransport;
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e, e);
                return;
            }
            ConcurrentHashMap e = this.bridges;
            synchronized (e) {
                if (this.bridges.containsKey(uri)) {
                    LOG.debug("Discovery agent generated a duplicate onServiceAdd event for: " + uri);
                    return;
                }
            }
            if (this.localURI.equals(uri)) {
                LOG.debug("not connecting loopback: " + uri);
                return;
            }
            if (this.connectionFilter != null && !this.connectionFilter.connectTo(uri)) {
                LOG.debug("connectionFilter disallows connection to: " + uri);
                return;
            }
            URI connectUri = uri;
            try {
                connectUri = URISupport.applyParameters(connectUri, this.parameters, "discovered.");
            }
            catch (URISyntaxException e2) {
                LOG.warn("could not apply query parameters: " + this.parameters + " to: " + connectUri, e2);
            }
            LOG.info("Establishing network connection from " + this.localURI + " to " + connectUri);
            try {
                SslContext.setCurrentSslContext(this.getBrokerService().getSslContext());
                try {
                    remoteTransport = TransportFactory.connect(connectUri);
                }
                catch (Exception e3) {
                    LOG.warn("Could not connect to remote URI: " + connectUri + ": " + e3.getMessage());
                    LOG.debug("Connection failure exception: " + e3, e3);
                    SslContext.setCurrentSslContext(null);
                    return;
                }
                try {
                    localTransport = this.createLocalTransport();
                }
                catch (Exception e4) {
                    ServiceSupport.dispose(remoteTransport);
                    LOG.warn("Could not connect to local URI: " + this.localURI + ": " + e4.getMessage());
                    LOG.debug("Connection failure exception: " + e4, e4);
                    SslContext.setCurrentSslContext(null);
                    return;
                }
            }
            finally {
                SslContext.setCurrentSslContext(null);
            }
            NetworkBridge bridge = this.createBridge(localTransport, remoteTransport, event);
            try {
                bridge.start();
                ConcurrentHashMap concurrentHashMap = this.bridges;
                synchronized (concurrentHashMap) {
                    this.bridges.put(uri, bridge);
                }
            }
            catch (Exception e5) {
                ServiceSupport.dispose(localTransport);
                ServiceSupport.dispose(remoteTransport);
                LOG.warn("Could not start network bridge between: " + this.localURI + " and: " + uri + " due to: " + e5);
                LOG.debug("Start failure exception: " + e5, e5);
                try {
                    this.discoveryAgent.serviceFailed(event);
                }
                catch (IOException e1) {
                    LOG.debug("Discovery agent failure while handling failure event: " + e1.getMessage(), e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceRemove(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e, e);
                return;
            }
            ConcurrentHashMap concurrentHashMap = this.bridges;
            synchronized (concurrentHashMap) {
                NetworkBridge bridge = (NetworkBridge)this.bridges.remove(uri);
            }
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
        if (discoveryAgent != null) {
            this.discoveryAgent.setDiscoveryListener(this);
        }
    }

    @Override
    protected void handleStart() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("You must configure the 'discoveryAgent' property");
        }
        this.discoveryAgent.start();
        super.handleStart();
    }

    @Override
    protected void handleStop(ServiceStopper stopper) throws Exception {
        for (NetworkBridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        this.bridges.clear();
        try {
            this.discoveryAgent.stop();
        }
        catch (Exception e) {
            stopper.onException(this, e);
        }
        super.handleStop(stopper);
    }

    protected NetworkBridge createBridge(Transport localTransport, Transport remoteTransport, final DiscoveryEvent event) {
        class DiscoverNetworkBridgeListener
        extends MBeanNetworkListener {
            public DiscoverNetworkBridgeListener(BrokerService brokerService, ObjectName connectorName) {
                super(brokerService, connectorName);
            }

            @Override
            public void bridgeFailed() {
                if (!DiscoveryNetworkConnector.this.serviceSupport.isStopped()) {
                    try {
                        DiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        DiscoverNetworkBridgeListener listener = new DiscoverNetworkBridgeListener(this.getBrokerService(), this.getObjectName());
        DemandForwardingBridge result = NetworkBridgeFactory.createBridge(this, localTransport, remoteTransport, listener);
        result.setBrokerService(this.getBrokerService());
        return this.configureBridge(result);
    }

    public String toString() {
        return "DiscoveryNetworkConnector:" + this.getName() + ":" + this.getBrokerService();
    }
}

