/*
 * (c) 2001-2009, Progress Software Corporation and/or its subsidiaries or affiliates.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fusesource.commons.management.noop;

import java.util.EventObject;

import org.fusesource.commons.management.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.fusesource.commons.management.Statistic.UpdateMode;

/**
 * An implementation of the ManagementStrategy interface that acts as a sink and does nothing.
 * <p>
 * Intended for use when no management is required.
 */
public class ManagementStrategyImpl implements ManagementStrategy {
    
    public void manageObject(Object managedObject) throws Exception {
    }

    public <T> T getManagedObjectName(Object managableObject, String customName, Class<T> nameType)
        throws Exception {
        return null;
    }

    public void manageNamedObject(Object managedObject, Object preferedName) throws Exception {
    }

    public void unmanageObject(Object managedObject) throws Exception {
    }
    
    public void unmanageNamedObject(Object name) throws Exception {
    }
     
    public boolean isManaged(Object managableObject, Object name) {
        return false;
    }

    public void notify(EventObject event) throws Exception {
    }
    
    public Statistic createStatistic(String name, Object owner, UpdateMode updateMode) {
        return new StatisticImpl();
    }
}
