/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.bai.backend.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.util.JSON;
import com.mongodb.util.JSONParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.dataformat.xmljson.XmlJsonDataFormat;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeRedeliveryEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.util.ServiceHelper;
import org.fusesource.bai.AuditEvent;
import org.fusesource.bai.backend.BAIAuditBackend;
import org.fusesource.bai.backend.BAIAuditBackendSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBBackend
extends BAIAuditBackendSupport
implements BAIAuditBackend {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBBackend.class);
    private Mongo mongo;
    private String dbname;
    private DB db;
    private CamelContext context;
    private TypeConverter typeConverter;
    private Properties typeHints;
    private XmlJsonDataFormat xmlJson = new XmlJsonDataFormat();
    private boolean debug = true;

    public void audit(AuditEvent ev) {
        String endpointId = ev.getEndpointURI();
        String srcContextId = ev.getExchange().getContext().getName();
        String srcRouteId = ev.getExchange().getFromRouteId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received AuditEvent: " + ev + " breadCrumbID: " + ev.getBreadCrumbId() + " | Extracted data: " + endpointId + ", " + srcContextId + ", " + srcRouteId);
        }
        boolean handled = false;
        if (ev.getEvent() instanceof ExchangeSendingEvent || ev.getEvent() instanceof ExchangeSentEvent || ev.getEvent() instanceof ExchangeCreatedEvent || ev.getEvent() instanceof ExchangeCompletedEvent) {
            this.digestExchangeEvent(ev);
            handled = true;
        } else if (ev.getEvent() instanceof ExchangeFailedEvent) {
            this.digestEndpointFailureEvent(ev);
            handled = true;
        } else if (ev.getEvent() instanceof ExchangeRedeliveryEvent) {
            if (ev.getEndpointURI() != null) {
                this.digestEndpointRedeliveryEvent(ev);
            } else {
                this.digestProcessorRedeliveryEvent(ev);
            }
            handled = true;
        }
        if (handled) {
            this.addToMetaCollection(ev);
        }
        if (this.debug) {
            this.createDebugRecord(ev);
        }
    }

    private void createDebugRecord(AuditEvent ev) {
        BasicDBObject object = new BasicDBObject();
        object.append("breadCrumbId", (Object)ev.getBreadCrumbId());
        object.append("eventtype", (Object)ev.getEvent().getClass().getName());
        object.append("endpointURI", (Object)ev.getEndpointURI());
        object.append("exchangeId", (Object)ev.getExchange().getExchangeId());
        object.append("exception", ev.getException() == null ? null : ev.getException().toString());
        object.append("redelivered", (Object)ev.getRedelivered());
        object.append("timestamp", (Object)ev.getTimestamp());
        object.append("sourceContextId", (Object)ev.getSourceContextId());
        object.append("sourceRouteId", (Object)ev.getSourceRouteId());
        object.append("inBody", ev.getEvent().getExchange().getIn().getBody(String.class));
        object.append("outBody", ev.getEvent().getExchange().hasOut() ? (String)ev.getEvent().getExchange().getOut().getBody(String.class) : null);
        this.db.getCollection("baievents").insert(new DBObject[]{object});
    }

    private void digestExchangeEvent(AuditEvent ev) {
        AbstractExchangeEvent event = ev.getEvent();
        if (event instanceof ExchangeCreatedEvent) {
            this.digestExchangeCreatedEvent(ev);
        }
        if (event instanceof ExchangeCompletedEvent) {
            this.digestExchangeCompletedEvent(ev);
        }
        if (event instanceof ExchangeSendingEvent) {
            this.digestExchangeSendingEvent(ev);
        }
        if (event instanceof ExchangeSentEvent) {
            this.digestExchangeSentEvent(ev);
        }
    }

    private void digestExchangeCreatedEvent(AuditEvent ev) {
        Object inMessage = null;
        try {
            inMessage = this.convertPayload(ev.getExchange().getIn().getBody(), ev.getExchange());
        }
        catch (Exception e) {
            // empty catch block
        }
        DBObject exchObj = BasicDBObjectBuilder.start().append("endpointUri", (Object)ev.getEndpointURI()).append("startTimestamp", (Object)ev.getTimestamp()).append("status", (Object)"in_progress").append("exchangeId", (Object)ev.getEvent().getExchange().getExchangeId()).append("exchangePattern", (Object)ev.getEvent().getExchange().getPattern().toString()).append("in", inMessage).append("dispatchId", ev.getEvent().getExchange().getProperty("AuditDispatchId", String.class)).get();
        DBObject toInsert = BasicDBObjectBuilder.start().append("_id", (Object)ev.getBreadCrumbId()).append("input", Arrays.asList(exchObj)).get();
        this.addCurrentRouteIdIfNeeded(ev, exchObj);
        this.collectionFor(ev).insert(new DBObject[]{toInsert});
    }

    private void digestExchangeCompletedEvent(AuditEvent ev) {
        DBObject filter = BasicDBObjectBuilder.start().append("_id", (Object)ev.getBreadCrumbId()).append("input.endpointUri", (Object)ev.getEndpointURI()).append("input.exchangeId", (Object)ev.getExchange().getExchangeId()).append("exchanges.dispatchId", ev.getEvent().getExchange().getProperty("AuditDispatchId", String.class)).get();
        BasicDBObject toApply = new BasicDBObject();
        toApply.put("$set", (Object)new BasicDBObject());
        BasicDBObject toSet = (BasicDBObject)toApply.get("$set");
        toSet.put("input.$.endTimestamp", (Object)ev.getTimestamp());
        toSet.put("input.$.status", (Object)"finished");
        if (ev.getEvent().getExchange().getPattern() == ExchangePattern.InOut) {
            Object outBody = null;
            try {
                outBody = ev.getExchange().hasOut() ? ev.getExchange().getOut().getBody() : ev.getExchange().getIn().getBody();
                toSet.put("input.$.out", this.convertPayload(outBody, ev.getExchange()));
                toSet.put("input.$.originalOut", this.typeConverter.convertTo(String.class, outBody));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.collectionFor(ev).update(filter, (DBObject)toApply);
    }

    private void digestExchangeSendingEvent(AuditEvent ev) {
        BasicDBObject filter = new BasicDBObject();
        filter.put("_id", (Object)ev.getBreadCrumbId());
        BasicDBObject toApply = new BasicDBObject();
        toApply.put("$push", (Object)new BasicDBObject("exchanges", (Object)new BasicDBObject()));
        BasicDBObject exchangeToPush = (BasicDBObject)((BasicDBObject)toApply.get("$push")).get("exchanges");
        exchangeToPush.put("endpointUri", (Object)ev.getEndpointURI());
        exchangeToPush.put("startTimestamp", (Object)ev.getTimestamp());
        exchangeToPush.put("status", (Object)"in_progress");
        exchangeToPush.put("exchangeId", (Object)ev.getEvent().getExchange().getExchangeId());
        exchangeToPush.put("exchangePattern", (Object)ev.getEvent().getExchange().getPattern().toString());
        exchangeToPush.put("dispatchId", ev.getEvent().getExchange().getProperty("AuditDispatchId", String.class));
        this.addCurrentRouteIdIfNeeded(ev, (DBObject)exchangeToPush);
        try {
            exchangeToPush.put("in", this.convertPayload(ev.getExchange().getIn().getBody(), ev.getExchange()));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.collectionFor(ev).update((DBObject)filter, (DBObject)toApply);
    }

    private void digestExchangeSentEvent(AuditEvent ev) {
        DBObject filter = BasicDBObjectBuilder.start().append("_id", (Object)ev.getBreadCrumbId()).append("exchanges.endpointUri", (Object)ev.getEndpointURI()).append("exchanges.exchangeId", (Object)ev.getExchange().getExchangeId()).append("exchanges.dispatchId", ev.getEvent().getExchange().getProperty("AuditDispatchId", String.class)).get();
        DBObject toApply = BasicDBObjectBuilder.start().push("$set").append("exchanges.$.endTimestamp", (Object)ev.getTimestamp()).append("exchanges.$.status", (Object)"finished").get();
        if (ev.getEvent().getExchange().getPattern() == ExchangePattern.InOut) {
            Object outBody = null;
            try {
                outBody = ev.getExchange().hasOut() ? ev.getExchange().getOut().getBody() : ev.getExchange().getIn().getBody();
                ((BasicDBObject)toApply.get("$set")).put("exchanges.$.out", this.convertPayload(outBody, ev.getExchange()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.collectionFor(ev).update(filter, toApply);
    }

    private void digestEndpointFailureEvent(AuditEvent ev) {
        BasicDBObject filter = new BasicDBObject("_id", (Object)ev.getBreadCrumbId());
        DBObject toUpdate = BasicDBObjectBuilder.start().push("$push").push("endpointFailures").append("endpointUri", (Object)ev.getEndpointURI()).append("exception", (Object)ev.getException().toString()).append("timestamp", (Object)ev.getTimestamp()).get();
        this.collectionFor(ev).update((DBObject)filter, toUpdate);
        this.addCurrentRouteIdIfNeeded(ev, (DBObject)((DBObject)toUpdate.get("$push")).get("endpointFailures"));
        filter.put("exchanges.endpointUri", (Object)ev.getEndpointURI());
        filter.put("exchanges.exchangeId", (Object)ev.getEvent().getExchange().getExchangeId());
        filter.put("exchanges.dispatchId", ev.getEvent().getExchange().getProperty("AuditDispatchId", String.class));
        toUpdate = BasicDBObjectBuilder.start().push("$set").append("exchanges.$.status", (Object)"failed").append("exchanges.$.failTimestamp", (Object)ev.getTimestamp()).get();
        if (ev.getException() != null) {
            ((BasicDBObject)toUpdate.get("$set")).put("exchanges.$.exception", (Object)ev.getException().toString());
        }
        this.collectionFor(ev).update((DBObject)filter, toUpdate);
        filter.put("in.endpointUri", (Object)ev.getEndpointURI());
        filter.put("in.exchangeId", (Object)ev.getEvent().getExchange().getExchangeId());
        filter.put("in.dispatchId", ev.getEvent().getExchange().getProperty("AuditDispatchId", String.class));
        toUpdate = BasicDBObjectBuilder.start().push("$set").append("in.$.status", (Object)"failed").append("in.$.failTimestamp", (Object)ev.getTimestamp()).get();
        if (ev.getException() != null) {
            ((BasicDBObject)toUpdate.get("$set")).put("in.$.exception", (Object)ev.getException().toString());
        }
        this.collectionFor(ev).update((DBObject)filter, toUpdate);
    }

    private void digestEndpointRedeliveryEvent(AuditEvent ev) {
        BasicDBObject filter = new BasicDBObject("_id", (Object)ev.getBreadCrumbId());
        DBObject toPush = BasicDBObjectBuilder.start().push("$push").push("endpointRedeliveries").append("exchangeId", (Object)ev.getExchange().getExchangeId()).append("endpointURI", (Object)ev.getEndpointURI()).append("timestamp", (Object)ev.getTimestamp()).append("exception", (Object)ev.getException().toString()).append("attempt", ev.getExchange().getProperty("CamelRedeliveryCounter")).get();
        this.collectionFor(ev).update((DBObject)filter, toPush);
    }

    private void digestProcessorRedeliveryEvent(AuditEvent ev) {
        BasicDBObject filter = new BasicDBObject("_id", (Object)ev.getBreadCrumbId());
        DBObject toPush = BasicDBObjectBuilder.start().push("$push").push("processorRedeliveries").append("exchangeId", (Object)ev.getExchange().getExchangeId()).append("timestamp", (Object)ev.getTimestamp()).append("exception", (Object)ev.getException().toString()).append("attempt", ev.getExchange().getProperty("CamelRedeliveryCounter")).get();
        this.collectionFor(ev).update((DBObject)filter, toPush);
    }

    private void addCurrentRouteIdIfNeeded(AuditEvent ev, DBObject dbo) {
        if (ev.getCurrentRouteId() != null && !ev.getCurrentRouteId().equals(ev.getSourceRouteId())) {
            dbo.put("currentRouteId", (Object)ev.getCurrentRouteId());
        }
    }

    private void addToMetaCollection(AuditEvent ev) {
        BasicDBObject filter = new BasicDBObject("_id", (Object)ev.getBreadCrumbId());
        BasicDBObject dbo = new BasicDBObject("$addToSet", (Object)new BasicDBObject("routes", (Object)(ev.getSourceContextId() + "." + ev.getSourceRouteId())));
        DBCollection collection = this.db.getCollection("exchangeXray");
        collection.update((DBObject)filter, (DBObject)dbo, true, false);
    }

    private DBCollection collectionFor(AuditEvent ev) {
        return this.db.getCollection(ev.getSourceContextId() + "." + ev.getSourceRouteId());
    }

    private Object convertPayload(Object payload, Exchange exchange) throws Exception {
        Expression expression = this.getStoreBodyExpression();
        if (expression != null) {
            payload = expression.evaluate(exchange, Object.class);
        }
        if (payload == null) {
            return null;
        }
        String s = (String)this.typeConverter.convertTo(String.class, payload);
        if (s.startsWith("{")) {
            Object answer = null;
            try {
                answer = JSON.parse((String)s);
            }
            catch (JSONParseException ex) {
                LOG.warn("Attempt to convert " + payload + " to JSON failed: " + (Object)((Object)ex), (Throwable)ex);
            }
            if (answer != null) {
                return answer;
            }
        }
        if (s.startsWith("<")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.xmlJson.marshal(exchange, payload, (OutputStream)baos);
                if (baos != null && baos.size() > 0) {
                    String json = (String)this.typeConverter.convertTo(String.class, (Object)baos);
                    return JSON.parse((String)json);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        if (payload instanceof String) {
            return payload;
        }
        return this.typeConverter.convertTo(DBObject.class, payload);
    }

    public void init() throws Exception {
        this.db = this.mongo.getDB(this.dbname);
        this.typeConverter = this.context.getTypeConverter();
        this.typeHints = new Properties();
        try {
            this.typeHints.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("typeHints.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.xmlJson.setForceTopLevelObject(Boolean.valueOf(true));
        ServiceHelper.startService((Service)this.xmlJson);
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public void setMongo(Mongo mongo) {
        this.mongo = mongo;
    }

    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public void setContext(CamelContext context) {
        this.context = context;
    }
}

