/*
 * Decompiled with CFR 0.152.
 */
package io.fury.util;

import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.function.Functions;
import io.fury.util.function.ToByteFunction;
import io.fury.util.function.ToCharFunction;
import io.fury.util.function.ToFloatFunction;
import io.fury.util.function.ToShortFunction;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class FieldAccessor {
    protected final Field field;
    protected final long fieldOffset;

    public FieldAccessor(Field field) {
        long fieldOffset;
        this.field = field;
        Preconditions.checkNotNull(field);
        try {
            fieldOffset = Platform.UNSAFE.objectFieldOffset(field);
        }
        catch (UnsupportedOperationException e) {
            fieldOffset = -1L;
        }
        this.fieldOffset = fieldOffset;
    }

    protected FieldAccessor(Field field, long fieldOffset) {
        this.field = field;
        this.fieldOffset = fieldOffset;
    }

    public abstract Object get(Object var1);

    public void set(Object obj, Object value) {
        throw new UnsupportedOperationException("Unsupported for field " + this.field);
    }

    public Field getField() {
        return this.field;
    }

    public final void putObject(Object targetObject, Object object) {
        if (this.fieldOffset != -1L) {
            Platform.putObject(targetObject, this.fieldOffset, object);
        } else {
            this.set(targetObject, object);
        }
    }

    public final Object getObject(Object targetObject) {
        if (this.fieldOffset != -1L) {
            return Platform.getObject(targetObject, this.fieldOffset);
        }
        return this.get(targetObject);
    }

    public long getFieldOffset() {
        return this.fieldOffset;
    }

    void checkObj(Object obj) {
        if (!this.field.getDeclaringClass().isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Illegal class " + obj.getClass());
        }
    }

    public static FieldAccessor createAccessor(Field field) {
        try {
            Platform.UNSAFE.objectFieldOffset(field);
        }
        catch (UnsupportedOperationException e) {
            Object getter;
            try {
                Method getterMethod = field.getDeclaringClass().getDeclaredMethod(field.getName(), new Class[0]);
                getter = Functions.makeGetterFunction(getterMethod);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            if (getter instanceof Predicate) {
                return new BooleanGetter(field, (Predicate)getter);
            }
            if (getter instanceof ToByteFunction) {
                return new ByteGetter(field, (ToByteFunction)getter);
            }
            if (getter instanceof ToCharFunction) {
                return new CharGetter(field, (ToCharFunction)getter);
            }
            if (getter instanceof ToShortFunction) {
                return new ShortGetter(field, (ToShortFunction)getter);
            }
            if (getter instanceof ToIntFunction) {
                return new IntGetter(field, (ToIntFunction)getter);
            }
            if (getter instanceof ToLongFunction) {
                return new LongGetter(field, (ToLongFunction)getter);
            }
            if (getter instanceof ToFloatFunction) {
                return new FloatGetter(field, (ToFloatFunction)getter);
            }
            if (getter instanceof ToDoubleFunction) {
                return new DoubleGetter(field, (ToDoubleFunction)getter);
            }
            return new ObjectGetter(field, (Function)getter);
        }
        if (field.getType() == Boolean.TYPE) {
            return new BooleanAccessor(field);
        }
        if (field.getType() == Byte.TYPE) {
            return new ByteAccessor(field);
        }
        if (field.getType() == Character.TYPE) {
            return new CharAccessor(field);
        }
        if (field.getType() == Short.TYPE) {
            return new ShortAccessor(field);
        }
        if (field.getType() == Integer.TYPE) {
            return new IntAccessor(field);
        }
        if (field.getType() == Long.TYPE) {
            return new LongAccessor(field);
        }
        if (field.getType() == Float.TYPE) {
            return new FloatAccessor(field);
        }
        if (field.getType() == Double.TYPE) {
            return new DoubleAccessor(field);
        }
        return new ObjectAccessor(field);
    }

    public static class BooleanGetter
    extends FieldGetter {
        private final Predicate getter;

        public BooleanGetter(Field field, Predicate getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Boolean.TYPE);
        }

        @Override
        public Boolean get(Object obj) {
            this.checkObj(obj);
            return this.getter.test(obj);
        }
    }

    public static class ByteGetter
    extends FieldGetter {
        private final ToByteFunction getter;

        public ByteGetter(Field field, ToByteFunction getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Byte.TYPE);
        }

        @Override
        public Byte get(Object obj) {
            return this.getter.applyAsByte(obj);
        }
    }

    public static class CharGetter
    extends FieldGetter {
        private final ToCharFunction getter;

        public CharGetter(Field field, ToCharFunction getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Character.TYPE);
        }

        @Override
        public Character get(Object obj) {
            return Character.valueOf(this.getter.applyAsChar(obj));
        }
    }

    public static class ShortGetter
    extends FieldGetter {
        private final ToShortFunction getter;

        public ShortGetter(Field field, ToShortFunction getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Short.TYPE);
        }

        @Override
        public Short get(Object obj) {
            return this.getter.applyAsShort(obj);
        }
    }

    public static class IntGetter
    extends FieldGetter {
        private final ToIntFunction getter;

        public IntGetter(Field field, ToIntFunction getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Integer.TYPE);
        }

        @Override
        public Integer get(Object obj) {
            return this.getter.applyAsInt(obj);
        }
    }

    public static class LongGetter
    extends FieldGetter {
        private final ToLongFunction getter;

        public LongGetter(Field field, ToLongFunction getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Long.TYPE);
        }

        @Override
        public Long get(Object obj) {
            return this.getter.applyAsLong(obj);
        }
    }

    public static class FloatGetter
    extends FieldGetter {
        private final ToFloatFunction getter;

        public FloatGetter(Field field, ToFloatFunction getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Float.TYPE);
        }

        @Override
        public Float get(Object obj) {
            return Float.valueOf(this.getter.applyAsFloat(obj));
        }
    }

    public static class DoubleGetter
    extends FieldGetter {
        private final ToDoubleFunction getter;

        public DoubleGetter(Field field, ToDoubleFunction getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(field.getType() == Double.TYPE);
        }

        @Override
        public Double get(Object obj) {
            return this.getter.applyAsDouble(obj);
        }
    }

    public static class ObjectGetter
    extends FieldGetter {
        private final Function getter;

        public ObjectGetter(Field field, Function getter) {
            super(field, getter);
            this.getter = getter;
            Preconditions.checkArgument(!field.getType().isPrimitive(), field);
        }

        @Override
        public Object get(Object obj) {
            return this.getter.apply(obj);
        }
    }

    public static class BooleanAccessor
    extends FieldAccessor {
        public BooleanAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Boolean.TYPE);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return Platform.getBoolean(obj, this.fieldOffset);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putBoolean(obj, this.fieldOffset, (Boolean)value);
        }
    }

    public static class ByteAccessor
    extends FieldAccessor {
        public ByteAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Byte.TYPE);
        }

        @Override
        public Byte get(Object obj) {
            this.checkObj(obj);
            return Platform.getByte(obj, this.fieldOffset);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putByte(obj, this.fieldOffset, (Byte)value);
        }
    }

    public static class CharAccessor
    extends FieldAccessor {
        public CharAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Character.TYPE);
        }

        @Override
        public Character get(Object obj) {
            this.checkObj(obj);
            return Character.valueOf(Platform.getChar(obj, this.fieldOffset));
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putChar(obj, this.fieldOffset, ((Character)value).charValue());
        }
    }

    public static class ShortAccessor
    extends FieldAccessor {
        public ShortAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Short.TYPE);
        }

        @Override
        public Short get(Object obj) {
            this.checkObj(obj);
            return Platform.getShort(obj, this.fieldOffset);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putShort(obj, this.fieldOffset, (Short)value);
        }
    }

    public static class IntAccessor
    extends FieldAccessor {
        public IntAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Integer.TYPE);
        }

        @Override
        public Integer get(Object obj) {
            this.checkObj(obj);
            return Platform.getInt(obj, this.fieldOffset);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putInt(obj, this.fieldOffset, (Integer)value);
        }
    }

    public static class LongAccessor
    extends FieldAccessor {
        public LongAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Long.TYPE);
        }

        @Override
        public Long get(Object obj) {
            this.checkObj(obj);
            return Platform.getLong(obj, this.fieldOffset);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putLong(obj, this.fieldOffset, (Long)value);
        }
    }

    public static class FloatAccessor
    extends FieldAccessor {
        public FloatAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Float.TYPE);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return Float.valueOf(Platform.getFloat(obj, this.fieldOffset));
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putFloat(obj, this.fieldOffset, ((Float)value).floatValue());
        }
    }

    public static class DoubleAccessor
    extends FieldAccessor {
        public DoubleAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(field.getType() == Double.TYPE);
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return Platform.getDouble(obj, this.fieldOffset);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putDouble(obj, this.fieldOffset, (Double)value);
        }
    }

    public static class ObjectAccessor
    extends FieldAccessor {
        public ObjectAccessor(Field field) {
            super(field);
            Preconditions.checkArgument(!TypeUtils.isPrimitive(field.getType()));
        }

        @Override
        public Object get(Object obj) {
            this.checkObj(obj);
            return Platform.getObject(obj, this.fieldOffset);
        }

        @Override
        public void set(Object obj, Object value) {
            this.checkObj(obj);
            Platform.putObject(obj, this.fieldOffset, value);
        }
    }

    public static abstract class FieldGetter
    extends FieldAccessor {
        private final Object getter;

        protected FieldGetter(Field field, Object getter) {
            super(field);
            this.getter = getter;
        }

        public Object getGetter() {
            return this.getter;
        }
    }
}

