/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.collection.Tuple2;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.CompatibleSerializer;
import io.fury.serializer.ObjectSerializer;
import io.fury.serializer.Serializer;
import io.fury.serializer.StringSerializer;
import io.fury.type.Type;
import io.fury.type.TypeUtils;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import io.fury.util.Utils;
import io.fury.util.function.Functions;
import io.fury.util.unsafe._JDKAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.IdentityHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;

public class Serializers {
    static Tuple2<ToIntFunction, Function> builderCache;

    public static <T> Serializer<T> newSerializer(Fury fury, Class type, Class<? extends Serializer> serializerClass) {
        Serializer serializer = fury.getClassResolver().getSerializer(type, false);
        try {
            if (serializerClass == ObjectSerializer.class) {
                return new ObjectSerializer(fury, type);
            }
            if (serializerClass == CompatibleSerializer.class) {
                return new CompatibleSerializer(fury, type);
            }
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(serializerClass);
            try {
                MethodHandle ctr = lookup.findConstructor(serializerClass, MethodType.methodType(Void.TYPE, Fury.class, Class.class));
                return ctr.invoke(fury, type);
            }
            catch (NoSuchMethodException e) {
                Utils.ignore(e);
                try {
                    MethodHandle ctr = lookup.findConstructor(serializerClass, MethodType.methodType(Void.TYPE, Fury.class));
                    return ctr.invoke(fury);
                }
                catch (NoSuchMethodException e2) {
                    Utils.ignore(e2);
                    try {
                        MethodHandle ctr = lookup.findConstructor(serializerClass, MethodType.methodType(Void.TYPE, Class.class));
                        return ctr.invoke(type);
                    }
                    catch (NoSuchMethodException e3) {
                        return ReflectionUtils.getCtrHandle(serializerClass, new Class[0]).invoke();
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            fury.getClassResolver().resetSerializer(type, serializer);
            if (e.getCause() != null) {
                Platform.throwException(e.getCause());
            } else {
                Platform.throwException(e);
            }
        }
        catch (Throwable t) {
            fury.getClassResolver().resetSerializer(type, serializer);
            Platform.throwException(t);
        }
        throw new IllegalStateException("unreachable");
    }

    public static Object readPrimitiveValue(Fury fury, MemoryBuffer buffer, short classId) {
        switch (classId) {
            case 5: {
                return buffer.readBoolean();
            }
            case 6: {
                return buffer.readByte();
            }
            case 7: {
                return Character.valueOf(buffer.readChar());
            }
            case 8: {
                return buffer.readShort();
            }
            case 9: {
                if (fury.compressInt()) {
                    return buffer.readVarInt();
                }
                return buffer.readInt();
            }
            case 10: {
                return Float.valueOf(buffer.readFloat());
            }
            case 11: {
                return fury.readLong(buffer);
            }
            case 12: {
                return buffer.readDouble();
            }
        }
        throw new IllegalStateException("unreachable");
    }

    private static synchronized Tuple2<ToIntFunction, Function> getBuilderFunc() {
        if (builderCache == null) {
            Function getValue = (Function)Functions.makeGetterFunction(StringBuilder.class.getSuperclass(), "getValue");
            try {
                Method getCoderMethod = StringBuilder.class.getSuperclass().getDeclaredMethod("getCoder", new Class[0]);
                ToIntFunction getCoder = (ToIntFunction)Functions.makeGetterFunction(getCoderMethod, Integer.TYPE);
                builderCache = Tuple2.of(getCoder, getValue);
            }
            catch (NoSuchMethodException e) {
                builderCache = Tuple2.of(null, getValue);
            }
        }
        return builderCache;
    }

    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(Class.class, new ClassSerializer(fury));
        fury.registerSerializer(StringBuilder.class, new StringBuilderSerializer(fury));
        fury.registerSerializer(StringBuffer.class, new StringBufferSerializer(fury));
        fury.registerSerializer(BigInteger.class, new BigIntegerSerializer(fury));
        fury.registerSerializer(BigDecimal.class, new BigDecimalSerializer(fury));
        fury.registerSerializer(AtomicBoolean.class, new AtomicBooleanSerializer(fury));
        fury.registerSerializer(AtomicInteger.class, new AtomicIntegerSerializer(fury));
        fury.registerSerializer(AtomicLong.class, new AtomicLongSerializer(fury));
        fury.registerSerializer(AtomicReference.class, new AtomicReferenceSerializer(fury));
        fury.registerSerializer(Currency.class, new CurrencySerializer(fury));
        fury.registerSerializer(URI.class, new URISerializer(fury));
        fury.registerSerializer(Pattern.class, new RegexSerializer(fury));
        fury.registerSerializer(UUID.class, new UUIDSerializer(fury));
        fury.registerSerializer(Object.class, new EmptyObjectSerializer(fury));
    }

    public static final class ClassSerializer
    extends Serializer<Class> {
        private static final byte USE_CLASS_ID = 0;
        private static final byte USE_CLASSNAME = 1;
        private static final byte PRIMITIVE_FLAG = 2;
        private final IdentityHashMap<Class<?>, Byte> primitivesMap = new IdentityHashMap();
        private final Class<?>[] id2PrimitiveClasses = new Class[9];

        public ClassSerializer(Fury fury) {
            super(fury, Class.class);
            byte count = 0;
            for (Class<?> primitiveType : TypeUtils.getSortedPrimitiveClasses()) {
                this.primitivesMap.put(primitiveType, count);
                this.id2PrimitiveClasses[count] = primitiveType;
                count = (byte)(count + 1);
            }
        }

        @Override
        public void write(MemoryBuffer buffer, Class value) {
            this.fury.getClassResolver().writeClassInternal(buffer, value);
        }

        @Override
        public Class read(MemoryBuffer buffer) {
            return this.fury.getClassResolver().readClassInternal(buffer);
        }
    }

    public static final class StringBuilderSerializer
    extends AbstractStringBuilderSerializer<StringBuilder> {
        public StringBuilderSerializer(Fury fury) {
            super(fury, StringBuilder.class);
        }

        @Override
        public StringBuilder read(MemoryBuffer buffer) {
            return new StringBuilder(this.stringSerializer.readJavaString(buffer));
        }

        @Override
        public StringBuilder xread(MemoryBuffer buffer) {
            return new StringBuilder(this.stringSerializer.readUTF8String(buffer));
        }
    }

    public static final class StringBufferSerializer
    extends AbstractStringBuilderSerializer<StringBuffer> {
        public StringBufferSerializer(Fury fury) {
            super(fury, StringBuffer.class);
        }

        @Override
        public StringBuffer read(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readJavaString(buffer));
        }

        @Override
        public StringBuffer xread(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readUTF8String(buffer));
        }
    }

    public static final class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer(Fury fury) {
            super(fury, BigInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigInteger value) {
            byte[] bytes = value.toByteArray();
            Preconditions.checkArgument(bytes.length <= 16);
            buffer.writeByte((byte)bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigInteger read(MemoryBuffer buffer) {
            byte len = buffer.readByte();
            byte[] bytes = buffer.readBytes(len);
            return new BigInteger(bytes);
        }
    }

    public static final class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        public BigDecimalSerializer(Fury fury) {
            super(fury, BigDecimal.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigDecimal value) {
            byte[] bytes = value.unscaledValue().toByteArray();
            Preconditions.checkArgument(bytes.length <= 16);
            buffer.writeByte((byte)value.scale());
            buffer.writeByte((byte)bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigDecimal read(MemoryBuffer buffer) {
            byte scale = buffer.readByte();
            byte len = buffer.readByte();
            byte[] bytes = buffer.readBytes(len);
            BigInteger bigInteger = new BigInteger(bytes);
            return new BigDecimal(bigInteger, scale);
        }
    }

    public static final class AtomicBooleanSerializer
    extends Serializer<AtomicBoolean> {
        public AtomicBooleanSerializer(Fury fury) {
            super(fury, AtomicBoolean.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicBoolean value) {
            buffer.writeBoolean(value.get());
        }

        @Override
        public AtomicBoolean read(MemoryBuffer buffer) {
            return new AtomicBoolean(buffer.readBoolean());
        }
    }

    public static final class AtomicIntegerSerializer
    extends Serializer<AtomicInteger> {
        public AtomicIntegerSerializer(Fury fury) {
            super(fury, AtomicInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicInteger value) {
            buffer.writeInt(value.get());
        }

        @Override
        public AtomicInteger read(MemoryBuffer buffer) {
            return new AtomicInteger(buffer.readInt());
        }
    }

    public static final class AtomicLongSerializer
    extends Serializer<AtomicLong> {
        public AtomicLongSerializer(Fury fury) {
            super(fury, AtomicLong.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicLong value) {
            buffer.writeLong(value.get());
        }

        @Override
        public AtomicLong read(MemoryBuffer buffer) {
            return new AtomicLong(buffer.readLong());
        }
    }

    public static final class AtomicReferenceSerializer
    extends Serializer<AtomicReference> {
        public AtomicReferenceSerializer(Fury fury) {
            super(fury, AtomicReference.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicReference value) {
            this.fury.writeRef(buffer, value.get());
        }

        @Override
        public AtomicReference read(MemoryBuffer buffer) {
            return new AtomicReference<Object>(this.fury.readRef(buffer));
        }
    }

    public static final class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer(Fury fury) {
            super(fury, Currency.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Currency object) {
            this.fury.writeJavaString(buffer, object.getCurrencyCode());
        }

        @Override
        public Currency read(MemoryBuffer buffer) {
            String currencyCode = this.fury.readJavaString(buffer);
            return Currency.getInstance(currencyCode);
        }
    }

    public static final class URISerializer
    extends Serializer<URI> {
        public URISerializer(Fury fury) {
            super(fury, URI.class);
        }

        @Override
        public void write(MemoryBuffer buffer, URI uri) {
            this.fury.writeString(buffer, uri.toString());
        }

        @Override
        public URI read(MemoryBuffer buffer) {
            return URI.create(this.fury.readString(buffer));
        }
    }

    public static final class RegexSerializer
    extends Serializer<Pattern> {
        public RegexSerializer(Fury fury) {
            super(fury, Pattern.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Pattern pattern) {
            this.fury.writeJavaString(buffer, pattern.pattern());
            buffer.writeInt(pattern.flags());
        }

        @Override
        public Pattern read(MemoryBuffer buffer) {
            String regex = this.fury.readJavaString(buffer);
            int flags = buffer.readInt();
            return Pattern.compile(regex, flags);
        }
    }

    public static final class UUIDSerializer
    extends Serializer<UUID> {
        public UUIDSerializer(Fury fury) {
            super(fury, UUID.class);
        }

        @Override
        public void write(MemoryBuffer buffer, UUID uuid) {
            buffer.writeLong(uuid.getMostSignificantBits());
            buffer.writeLong(uuid.getLeastSignificantBits());
        }

        @Override
        public UUID read(MemoryBuffer buffer) {
            return new UUID(buffer.readLong(), buffer.readLong());
        }
    }

    public static final class EmptyObjectSerializer
    extends Serializer<Object> {
        public EmptyObjectSerializer(Fury fury) {
            super(fury, Object.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Object value) {
        }

        @Override
        public Object read(MemoryBuffer buffer) {
            return new Object();
        }
    }

    public static final class CharsetSerializer<T extends Charset>
    extends Serializer<T> {
        public CharsetSerializer(Fury fury, Class<T> type) {
            super(fury, type);
        }

        @Override
        public void write(MemoryBuffer buffer, T object) {
            this.fury.writeJavaString(buffer, ((Charset)object).name());
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)Charset.forName(this.fury.readJavaString(buffer));
        }
    }

    public static final class EnumSerializer
    extends Serializer<Enum> {
        private final Enum[] enumConstants;

        public EnumSerializer(Fury fury, Class<Enum> cls) {
            super(fury, cls, false);
            if (cls.isEnum()) {
                this.enumConstants = cls.getEnumConstants();
            } else {
                Preconditions.checkArgument(Enum.class.isAssignableFrom(cls) && cls != Enum.class);
                Class<?> enclosingClass = cls.getEnclosingClass();
                Preconditions.checkNotNull(enclosingClass);
                Preconditions.checkArgument(enclosingClass.isEnum());
                this.enumConstants = (Enum[])enclosingClass.getEnumConstants();
            }
        }

        @Override
        public void write(MemoryBuffer buffer, Enum value) {
            buffer.writePositiveVarInt(value.ordinal());
        }

        @Override
        public Enum read(MemoryBuffer buffer) {
            return this.enumConstants[buffer.readPositiveVarInt()];
        }
    }

    public static abstract class AbstractStringBuilderSerializer<T extends CharSequence>
    extends Serializer<T> {
        protected final ToIntFunction getCoder;
        protected final Function getValue;
        protected final StringSerializer stringSerializer;

        public AbstractStringBuilderSerializer(Fury fury, Class<T> type) {
            super(fury, type);
            Tuple2 builderFunc = Serializers.getBuilderFunc();
            this.getCoder = (ToIntFunction)builderFunc.f0;
            this.getValue = (Function)builderFunc.f1;
            this.stringSerializer = new StringSerializer(fury);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.stringSerializer.writeUTF8String(buffer, value.toString());
        }

        @Override
        public short getXtypeId() {
            return -Type.STRING.getId();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            if (this.getCoder != null) {
                int coder = this.getCoder.applyAsInt(value);
                byte[] v = (byte[])this.getValue.apply(value);
                buffer.writeByte(coder);
                if (coder == 0) {
                    buffer.writePrimitiveArrayWithSizeEmbedded(v, Platform.BYTE_ARRAY_OFFSET, value.length());
                } else {
                    if (coder != 1) {
                        throw new UnsupportedOperationException("Unsupported coder " + coder);
                    }
                    buffer.writePrimitiveArrayWithSizeEmbedded(v, Platform.BYTE_ARRAY_OFFSET, value.length() << 1);
                }
            } else {
                char[] v = (char[])this.getValue.apply(value);
                if (StringSerializer.isLatin(v)) {
                    this.stringSerializer.writeCharsLatin(buffer, v, value.length());
                } else {
                    this.stringSerializer.writeCharsUTF16(buffer, v, value.length());
                }
            }
        }
    }

    public static abstract class CrossLanguageCompatibleSerializer<T>
    extends Serializer<T> {
        private final short typeId;

        public CrossLanguageCompatibleSerializer(Fury fury, Class<T> cls, short typeId) {
            super(fury, cls);
            this.typeId = typeId;
        }

        public CrossLanguageCompatibleSerializer(Fury fury, Class<T> cls, short typeId, boolean needToWriteRef) {
            super(fury, cls, needToWriteRef);
            this.typeId = typeId;
        }

        @Override
        public short getXtypeId() {
            return this.typeId;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.write(buffer, value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            return this.read(buffer);
        }
    }
}

