/*
 * Decompiled with CFR 0.152.
 */
package io.fury.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.fury.collection.IdentityMap;
import io.fury.collection.Tuple2;
import io.fury.type.Descriptor;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeUtils {
    public static final String JAVA_BOOLEAN = "boolean";
    public static final String JAVA_BYTE = "byte";
    public static final String JAVA_SHORT = "short";
    public static final String JAVA_INT = "int";
    public static final String JAVA_LONG = "long";
    public static final String JAVA_FLOAT = "float";
    public static final String JAVA_DOUBLE = "double";
    public static final TypeToken<?> PRIMITIVE_VOID_TYPE = TypeToken.of(Void.TYPE);
    public static final TypeToken<?> VOID_TYPE = TypeToken.of(Void.class);
    public static final TypeToken<?> PRIMITIVE_BYTE_TYPE = TypeToken.of(Byte.TYPE);
    public static final TypeToken<?> PRIMITIVE_BOOLEAN_TYPE = TypeToken.of(Boolean.TYPE);
    public static final TypeToken<?> PRIMITIVE_CHAR_TYPE = TypeToken.of(Character.TYPE);
    public static final TypeToken<?> PRIMITIVE_SHORT_TYPE = TypeToken.of(Short.TYPE);
    public static final TypeToken<?> PRIMITIVE_INT_TYPE = TypeToken.of(Integer.TYPE);
    public static final TypeToken<?> PRIMITIVE_LONG_TYPE = TypeToken.of(Long.TYPE);
    public static final TypeToken<?> PRIMITIVE_FLOAT_TYPE = TypeToken.of(Float.TYPE);
    public static final TypeToken<?> PRIMITIVE_DOUBLE_TYPE = TypeToken.of(Double.TYPE);
    public static final TypeToken<?> BYTE_TYPE = TypeToken.of(Byte.class);
    public static final TypeToken<?> BOOLEAN_TYPE = TypeToken.of(Boolean.class);
    public static final TypeToken<?> CHAR_TYPE = TypeToken.of(Character.class);
    public static final TypeToken<?> SHORT_TYPE = TypeToken.of(Short.class);
    public static final TypeToken<?> INT_TYPE = TypeToken.of(Integer.class);
    public static final TypeToken<?> LONG_TYPE = TypeToken.of(Long.class);
    public static final TypeToken<?> FLOAT_TYPE = TypeToken.of(Float.class);
    public static final TypeToken<?> DOUBLE_TYPE = TypeToken.of(Double.class);
    public static final TypeToken<?> STRING_TYPE = TypeToken.of(String.class);
    public static final TypeToken<?> BIG_DECIMAL_TYPE = TypeToken.of(BigDecimal.class);
    public static final TypeToken<?> BIG_INTEGER_TYPE = TypeToken.of(BigInteger.class);
    public static final TypeToken<?> DATE_TYPE = TypeToken.of(Date.class);
    public static final TypeToken<?> LOCAL_DATE_TYPE = TypeToken.of(LocalDate.class);
    public static final TypeToken<?> TIMESTAMP_TYPE = TypeToken.of(Timestamp.class);
    public static final TypeToken<?> INSTANT_TYPE = TypeToken.of(Instant.class);
    public static final TypeToken<?> BINARY_TYPE = TypeToken.of(byte[].class);
    public static final TypeToken<?> ITERABLE_TYPE = TypeToken.of(Iterable.class);
    public static final TypeToken<?> COLLECTION_TYPE = TypeToken.of(Collection.class);
    public static final TypeToken<?> LIST_TYPE = TypeToken.of(List.class);
    public static final TypeToken<?> ARRAYLIST_TYPE = TypeToken.of(ArrayList.class);
    public static final TypeToken<?> SET_TYPE = TypeToken.of(Set.class);
    public static final TypeToken<?> HASHSET_TYPE = TypeToken.of(HashSet.class);
    public static final TypeToken<?> MAP_TYPE = TypeToken.of(Map.class);
    public static final TypeToken<?> HASHMAP_TYPE = TypeToken.of(HashMap.class);
    public static final TypeToken<?> OBJECT_TYPE = TypeToken.of(Object.class);
    public static Type ITERATOR_RETURN_TYPE;
    public static Type NEXT_RETURN_TYPE;
    public static Type KEY_SET_RETURN_TYPE;
    public static Type VALUES_RETURN_TYPE;
    public static final TypeToken<?> PRIMITIVE_BYTE_ARRAY_TYPE;
    public static final TypeToken<?> PRIMITIVE_BOOLEAN_ARRAY_TYPE;
    public static final TypeToken<?> PRIMITIVE_SHORT_ARRAY_TYPE;
    public static final TypeToken<?> PRIMITIVE_CHAR_ARRAY_TYPE;
    public static final TypeToken<?> PRIMITIVE_INT_ARRAY_TYPE;
    public static final TypeToken<?> PRIMITIVE_LONG_ARRAY_TYPE;
    public static final TypeToken<?> PRIMITIVE_FLOAT_ARRAY_TYPE;
    public static final TypeToken<?> PRIMITIVE_DOUBLE_ARRAY_TYPE;
    public static final TypeToken<?> OBJECT_ARRAY_TYPE;
    public static final TypeToken<?> CLASS_TYPE;
    public static Set<TypeToken<?>> SUPPORTED_TYPES;
    private static final List<Class<?>> sortedPrimitiveClasses;
    private static final List<Class<?>> sortedBoxedClasses;
    private static final int[] sortedSizes;
    private static final IdentityMap<Class<?>, Class<?>> primToWrap;
    private static final IdentityMap<Class<?>, Class<?>> wrapToPrim;

    public static boolean isNullable(Class<?> clz) {
        return !TypeUtils.isPrimitive(clz);
    }

    private static void add(IdentityMap<Class<?>, Class<?>> forward, IdentityMap<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static boolean isPrimitive(Class<?> clz) {
        return clz.isPrimitive();
    }

    public static boolean isBoxed(Class<?> clz) {
        return wrapToPrim.containsKey(clz);
    }

    public static Class<?> boxedType(Class<?> clz) {
        Preconditions.checkArgument((boolean)clz.isPrimitive());
        int index = sortedPrimitiveClasses.indexOf(clz);
        return sortedBoxedClasses.get(index);
    }

    public static List<Class<?>> getSortedPrimitiveClasses() {
        return sortedPrimitiveClasses;
    }

    public static List<Class<?>> getSortedBoxedClasses() {
        return sortedBoxedClasses;
    }

    public static Class<?> maxType(Class<?> ... numericTypes) {
        Preconditions.checkArgument((numericTypes.length >= 2 ? 1 : 0) != 0);
        int maxIndex = 0;
        for (Class<?> numericType : numericTypes) {
            int index = TypeUtils.isPrimitive(numericType) ? sortedPrimitiveClasses.indexOf(numericType) : sortedBoxedClasses.indexOf(numericType);
            if (index == -1) {
                throw new IllegalArgumentException(String.format("Wrong numericTypes %s", Arrays.toString(numericTypes)));
            }
            maxIndex = Math.max(maxIndex, index);
        }
        return sortedPrimitiveClasses.get(maxIndex);
    }

    public static int getSizeOfPrimitiveType(TypeToken<?> numericType) {
        return TypeUtils.getSizeOfPrimitiveType(TypeUtils.getRawType(numericType));
    }

    public static int getSizeOfPrimitiveType(Class<?> numericType) {
        if (TypeUtils.isPrimitive(numericType)) {
            int index = sortedPrimitiveClasses.indexOf(numericType);
            return sortedSizes[index];
        }
        String msg = String.format("Class %s must be primitive", numericType);
        throw new IllegalArgumentException(msg);
    }

    public static String defaultValue(Class<?> type) {
        return TypeUtils.defaultValue(type.getSimpleName(), false);
    }

    public static String defaultValue(String type) {
        return TypeUtils.defaultValue(type, false);
    }

    public static String defaultValue(String type, boolean typedNull) {
        switch (type) {
            case "boolean": {
                return "false";
            }
            case "byte": {
                return "(byte)0";
            }
            case "short": {
                return "(short)0";
            }
            case "int": {
                return "0";
            }
            case "long": {
                return "0L";
            }
            case "float": {
                return "0.0f";
            }
            case "double": {
                return "0.0";
            }
        }
        if (typedNull) {
            return String.format("((%s)null)", type);
        }
        return "null";
    }

    public static Class<?> getRawType(TypeToken<?> typeToken) {
        Type type = typeToken.getType();
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        return TypeUtils.getRawType(typeToken.getType());
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof TypeVariable) {
            return TypeUtils.getRawType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(TypeUtils.getRawType(TypeToken.of((Type)componentType)), 0).getClass();
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public static int getArrayDimensions(TypeToken<?> type) {
        return TypeUtils.getArrayDimensions(TypeUtils.getRawType(type));
    }

    public static int getArrayDimensions(Class<?> type) {
        return (Integer)TypeUtils.getArrayComponentInfo(type).f1;
    }

    public static Class<?> getArrayComponent(Class<?> type) {
        return (Class)TypeUtils.getArrayComponentInfo(type).f0;
    }

    public static Tuple2<Class<?>, Integer> getArrayComponentInfo(Class<?> type) {
        Class<?> t;
        Preconditions.checkArgument((boolean)type.isArray());
        int dimension = 0;
        for (t = type; t != null && t.isArray(); t = t.getComponentType()) {
            ++dimension;
        }
        return Tuple2.of(t, dimension);
    }

    public static String getArrayType(TypeToken<?> type) {
        return TypeUtils.getArrayType(TypeUtils.getRawType(type));
    }

    public static String getArrayType(Class<?> type) {
        Tuple2<Class<?>, Integer> info = TypeUtils.getArrayComponentInfo(type);
        StringBuilder typeBuilder = new StringBuilder(ReflectionUtils.getCanonicalName((Class)info.f0));
        for (int i = 0; i < (Integer)info.f1; ++i) {
            typeBuilder.append("[]");
        }
        return typeBuilder.toString();
    }

    public static String getArrayType(Class<?> elemType, int[] dimensions) {
        StringBuilder typeBuilder = new StringBuilder(ReflectionUtils.getCanonicalName(elemType));
        for (int i = 0; i < dimensions.length; ++i) {
            typeBuilder.append('[').append(dimensions[i]).append(']');
        }
        return typeBuilder.toString();
    }

    public static TypeToken<?> getMultiDimensionArrayElementType(TypeToken<?> type) {
        TypeToken t;
        for (t = type; t != null && t.isArray(); t = t.getComponentType()) {
        }
        return t;
    }

    public static TypeToken<?> getElementType(TypeToken<?> typeToken) {
        ParameterizedType parameterizedType;
        Type type = typeToken.getType();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == List.class) {
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Preconditions.checkState((actualTypeArguments.length == 1 ? 1 : 0) != 0);
            Type t = actualTypeArguments[0];
            if (t.getClass() == Class.class) {
                return TypeToken.of((Type)t);
            }
        }
        TypeToken supertype = typeToken.getSupertype(Iterable.class);
        return supertype.resolveType(ITERATOR_RETURN_TYPE).resolveType(NEXT_RETURN_TYPE);
    }

    public static TypeToken<?> getCollectionType(TypeToken<?> typeToken) {
        TypeToken supertype = typeToken.getSupertype(Iterable.class);
        return supertype.getSubtype(Collection.class);
    }

    public static Tuple2<TypeToken<?>, TypeToken<?>> getMapKeyValueType(TypeToken<?> typeToken) {
        ParameterizedType parameterizedType;
        Type type = typeToken.getType();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == Map.class) {
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Preconditions.checkState((actualTypeArguments.length == 2 ? 1 : 0) != 0);
            if (actualTypeArguments[0].getClass() == Class.class && actualTypeArguments[1].getClass() == Class.class) {
                return Tuple2.of(TypeToken.of((Type)actualTypeArguments[0]), TypeToken.of((Type)actualTypeArguments[1]));
            }
        }
        TypeToken supertype = typeToken.getSupertype(Map.class);
        TypeToken<?> keyType = TypeUtils.getElementType(supertype.resolveType(KEY_SET_RETURN_TYPE));
        TypeToken<?> valueType = TypeUtils.getElementType(supertype.resolveType(VALUES_RETURN_TYPE));
        return Tuple2.of(keyType, valueType);
    }

    public static <E> TypeToken<ArrayList<E>> arrayListOf(Class<E> elemType) {
        return new TypeToken<ArrayList<E>>(){}.where(new TypeParameter<E>(){}, elemType);
    }

    public static <E> TypeToken<List<E>> listOf(Class<E> elemType) {
        return new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, elemType);
    }

    public static <E> TypeToken<Collection<E>> collectionOf(Class<E> elemType) {
        return TypeUtils.collectionOf(TypeToken.of(elemType));
    }

    public static <E> TypeToken<Collection<E>> collectionOf(TypeToken<E> elemType) {
        return new TypeToken<Collection<E>>(){}.where(new TypeParameter<E>(){}, elemType);
    }

    public static <K, V> TypeToken<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return TypeUtils.mapOf(TypeToken.of(keyType), TypeToken.of(valueType));
    }

    public static <K, V> TypeToken<Map<K, V>> mapOf(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static <K, V> TypeToken<? extends Map<K, V>> mapOf(Class<?> mapType, TypeToken<K> keyType, TypeToken<V> valueType) {
        TypeToken<Map<K, V>> mapTypeToken = TypeUtils.mapOf(keyType, valueType);
        return mapTypeToken.getSubtype(mapType);
    }

    public static <K, V> TypeToken<? extends Map<K, V>> mapOf(Class<?> mapType, Class<K> keyType, Class<V> valueType) {
        TypeToken<Map<K, V>> mapTypeToken = TypeUtils.mapOf(keyType, valueType);
        return mapTypeToken.getSubtype(mapType);
    }

    public static <K, V> TypeToken<HashMap<K, V>> hashMapOf(Class<K> keyType, Class<V> valueType) {
        return new TypeToken<HashMap<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public static boolean isCollection(Class<?> cls) {
        return cls == ArrayList.class || Collection.class.isAssignableFrom(cls);
    }

    public static boolean isMap(Class<?> cls) {
        return cls == HashMap.class || Map.class.isAssignableFrom(cls);
    }

    public static boolean isBean(Type type) {
        return TypeUtils.isBean(TypeToken.of((Type)type));
    }

    public static boolean isBean(Class<?> clz) {
        return TypeUtils.isBean(TypeToken.of(clz));
    }

    public static boolean isBean(TypeToken<?> typeToken) {
        return TypeUtils.isBean(typeToken, new LinkedHashSet<TypeToken>());
    }

    private static boolean isBean(TypeToken<?> typeToken, LinkedHashSet<TypeToken> walkedTypePath) {
        Class<?> cls = TypeUtils.getRawType(typeToken);
        if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(cls.getModifiers())) {
            boolean maybe;
            if (cls.getEnclosingClass() != null && !Modifier.isStatic(cls.getModifiers())) {
                return false;
            }
            LinkedHashSet<TypeToken> newTypePath = new LinkedHashSet<TypeToken>(walkedTypePath);
            newTypePath.add(typeToken);
            if (cls == Object.class) {
                return false;
            }
            boolean bl = maybe = !SUPPORTED_TYPES.contains(typeToken) && !typeToken.isArray() && !cls.isEnum() && !ITERABLE_TYPE.isSupertypeOf(typeToken) && !MAP_TYPE.isSupertypeOf(typeToken);
            if (maybe) {
                return Descriptor.getDescriptors(cls).stream().allMatch(d -> {
                    TypeToken<?> t = d.getTypeToken();
                    return TypeUtils.isSupported(t, newTypePath) || TypeUtils.isBean(t, newTypePath);
                });
            }
            return false;
        }
        return false;
    }

    public static boolean isSupported(TypeToken<?> typeToken) {
        return TypeUtils.isSupported(typeToken, new LinkedHashSet<TypeToken>());
    }

    private static boolean isSupported(TypeToken<?> typeToken, LinkedHashSet<TypeToken> walkedTypePath) {
        Class<Object> cls = TypeUtils.getRawType(typeToken);
        if (!Modifier.isPublic(cls.getModifiers())) {
            return false;
        }
        if (cls == Object.class) {
            return true;
        }
        if (SUPPORTED_TYPES.contains(typeToken)) {
            return true;
        }
        if (typeToken.isArray()) {
            return TypeUtils.isSupported(Objects.requireNonNull(typeToken.getComponentType()));
        }
        if (ITERABLE_TYPE.isSupertypeOf(typeToken)) {
            boolean isSuperOfArrayList = cls.isAssignableFrom(ArrayList.class);
            boolean isSuperOfHashSet = cls.isAssignableFrom(HashSet.class);
            if (!isSuperOfArrayList && !isSuperOfHashSet && (cls.isInterface() || Modifier.isAbstract(cls.getModifiers()))) {
                return false;
            }
            return TypeUtils.isSupported(TypeUtils.getElementType(typeToken));
        }
        if (MAP_TYPE.isSupertypeOf(typeToken)) {
            boolean isSuperOfHashMap = cls.isAssignableFrom(HashMap.class);
            if (!isSuperOfHashMap && (cls.isInterface() || Modifier.isAbstract(cls.getModifiers()))) {
                return false;
            }
            Tuple2<TypeToken<?>, TypeToken<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeToken);
            return TypeUtils.isSupported((TypeToken)mapKeyValueType.f0) && TypeUtils.isSupported((TypeToken)mapKeyValueType.f1);
        }
        if (walkedTypePath.contains(typeToken)) {
            throw new UnsupportedOperationException("cyclic type is not supported. walkedTypePath: " + walkedTypePath);
        }
        LinkedHashSet<TypeToken> newTypePath = new LinkedHashSet<TypeToken>(walkedTypePath);
        newTypePath.add(typeToken);
        return TypeUtils.isBean(typeToken, newTypePath);
    }

    public static LinkedHashSet<Class<?>> listBeansRecursiveInclusive(Class<?> beanClass) {
        return TypeUtils.listBeansRecursiveInclusive(beanClass, new LinkedHashSet());
    }

    private static LinkedHashSet<Class<?>> listBeansRecursiveInclusive(Class<?> beanClass, LinkedHashSet<TypeToken<?>> walkedTypePath) {
        LinkedHashSet beans = new LinkedHashSet();
        if (TypeUtils.isBean(beanClass)) {
            beans.add(beanClass);
        }
        LinkedHashSet typeTokens = new LinkedHashSet();
        List<Descriptor> descriptors = Descriptor.getDescriptors(beanClass);
        for (Descriptor descriptor : descriptors) {
            TypeToken<?> typeToken2 = descriptor.getTypeToken();
            typeTokens.add(descriptor.getTypeToken());
            typeTokens.addAll(TypeUtils.getAllTypeArguments(typeToken2));
        }
        typeTokens.stream().filter(typeToken -> TypeUtils.isBean(TypeUtils.getRawType(typeToken))).forEach(typeToken -> {
            Class<?> cls = TypeUtils.getRawType(typeToken);
            beans.add(cls);
            if (walkedTypePath.contains(typeToken)) {
                throw new UnsupportedOperationException("cyclic type is not supported. walkedTypePath: " + walkedTypePath);
            }
            LinkedHashSet newPath = new LinkedHashSet(walkedTypePath);
            newPath.add((TypeToken<?>)typeToken);
            beans.addAll(TypeUtils.listBeansRecursiveInclusive(cls, newPath));
        });
        return beans;
    }

    public static int computeStringHash(String str) {
        byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
        long hash = 17L;
        for (byte b : strBytes) {
            for (hash = hash * 31L + (long)b; hash > Integer.MAX_VALUE; hash /= 7L) {
            }
        }
        return (int)hash;
    }

    public static List<TypeToken<?>> getTypeArguments(TypeToken typeToken) {
        if (typeToken.getType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeToken.getType();
            return Arrays.stream(parameterizedType.getActualTypeArguments()).map(TypeToken::of).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static List<TypeToken<?>> getAllTypeArguments(TypeToken typeToken) {
        List<TypeToken<?>> types = TypeUtils.getTypeArguments(typeToken);
        LinkedHashSet allTypeArguments = new LinkedHashSet(types);
        for (TypeToken<?> type : types) {
            allTypeArguments.addAll(TypeUtils.getAllTypeArguments(type));
        }
        return new ArrayList(allTypeArguments);
    }

    static {
        PRIMITIVE_BYTE_ARRAY_TYPE = TypeToken.of(byte[].class);
        PRIMITIVE_BOOLEAN_ARRAY_TYPE = TypeToken.of(boolean[].class);
        PRIMITIVE_SHORT_ARRAY_TYPE = TypeToken.of(short[].class);
        PRIMITIVE_CHAR_ARRAY_TYPE = TypeToken.of(char[].class);
        PRIMITIVE_INT_ARRAY_TYPE = TypeToken.of(int[].class);
        PRIMITIVE_LONG_ARRAY_TYPE = TypeToken.of(long[].class);
        PRIMITIVE_FLOAT_ARRAY_TYPE = TypeToken.of(float[].class);
        PRIMITIVE_DOUBLE_ARRAY_TYPE = TypeToken.of(double[].class);
        OBJECT_ARRAY_TYPE = TypeToken.of(Object[].class);
        CLASS_TYPE = TypeToken.of(Class.class);
        SUPPORTED_TYPES = new HashSet();
        SUPPORTED_TYPES.add(PRIMITIVE_BYTE_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_BOOLEAN_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_CHAR_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_SHORT_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_INT_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_LONG_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_FLOAT_TYPE);
        SUPPORTED_TYPES.add(PRIMITIVE_DOUBLE_TYPE);
        SUPPORTED_TYPES.add(BYTE_TYPE);
        SUPPORTED_TYPES.add(BOOLEAN_TYPE);
        SUPPORTED_TYPES.add(CHAR_TYPE);
        SUPPORTED_TYPES.add(SHORT_TYPE);
        SUPPORTED_TYPES.add(INT_TYPE);
        SUPPORTED_TYPES.add(LONG_TYPE);
        SUPPORTED_TYPES.add(FLOAT_TYPE);
        SUPPORTED_TYPES.add(DOUBLE_TYPE);
        SUPPORTED_TYPES.add(STRING_TYPE);
        SUPPORTED_TYPES.add(BIG_DECIMAL_TYPE);
        SUPPORTED_TYPES.add(DATE_TYPE);
        SUPPORTED_TYPES.add(LOCAL_DATE_TYPE);
        SUPPORTED_TYPES.add(TIMESTAMP_TYPE);
        SUPPORTED_TYPES.add(INSTANT_TYPE);
        try {
            ITERATOR_RETURN_TYPE = Iterable.class.getMethod("iterator", new Class[0]).getGenericReturnType();
            NEXT_RETURN_TYPE = Iterator.class.getMethod("next", new Class[0]).getGenericReturnType();
            KEY_SET_RETURN_TYPE = Map.class.getMethod("keySet", new Class[0]).getGenericReturnType();
            VALUES_RETURN_TYPE = Map.class.getMethod("values", new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        sortedPrimitiveClasses = ImmutableList.of(Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE);
        sortedBoxedClasses = ImmutableList.of(Void.class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Float.class, Long.class, Double.class);
        sortedSizes = new int[]{0, 1, 1, 2, 2, 4, 4, 8, 8};
        primToWrap = new IdentityMap(9);
        wrapToPrim = new IdentityMap(9);
        TypeUtils.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        TypeUtils.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        TypeUtils.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        TypeUtils.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        TypeUtils.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        TypeUtils.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        TypeUtils.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        TypeUtils.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        TypeUtils.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
    }
}

